/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.sql.impl;

import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.parser.sql.SqlParser;

public final class UpdateSql
implements SqlParser {
    private String sql;
    private String sourceTableName;
    private String targetTableName;
    private List<FieldMapping> fieldMappingList;

    public UpdateSql(String sql, String sourceTableName, String targetTableName, List<FieldMapping> fieldMappingList) {
        this.sql = sql;
        this.sourceTableName = sourceTableName;
        this.targetTableName = targetTableName;
        this.fieldMappingList = fieldMappingList;
    }

    @Override
    public String parse() {
        try {
            Update update = (Update)CCJSqlParserUtil.parse((String)this.sql);
            Table table = new Table();
            table.setName(this.targetTableName);
            update.setTable(table);
            for (UpdateSet updateSet : update.getUpdateSets()) {
                ExpressionList columns = updateSet.getColumns();
                for (Column column : columns) {
                    this.fieldMappingList.stream().filter(x -> x.getSource().getName().equals(column.getColumnName().replaceAll("\"", ""))).findFirst().ifPresent(fieldMapping -> column.setColumnName(fieldMapping.getTarget().getName()));
                }
            }
            this.whereParse(update.getWhere());
            return update.toString();
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
    }

    private void whereParse(Expression expression) {
        BinaryExpression binaryExpression = (BinaryExpression)expression;
        Expression left = binaryExpression.getLeftExpression();
        Expression right = binaryExpression.getRightExpression();
        this.findColumn((BinaryExpression)left);
        this.findColumn((BinaryExpression)right);
    }

    private void findColumn(BinaryExpression binaryExpression) {
        if (binaryExpression.getLeftExpression() instanceof Column) {
            Column column = (Column)binaryExpression.getLeftExpression();
            this.fieldMappingList.stream().filter(x -> x.getSource().getName().equals(column.getColumnName().replaceAll("\"", ""))).findFirst().ifPresent(fieldMapping -> column.setColumnName(fieldMapping.getTarget().getName()));
            return;
        }
        this.findColumn((BinaryExpression)binaryExpression.getLeftExpression());
        this.findColumn((BinaryExpression)binaryExpression.getRightExpression());
    }
}

