/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.dbsyncer.biz.SystemConfigService;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.common.config.AppConfig;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.parser.CacheService;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.storage.impl.SnowflakeIdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/config"})
public class ConfigController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SystemConfigService systemConfigService;
    @Resource
    private CacheService cacheService;
    @Resource
    private LogService logService;
    @Resource
    private AppConfig appConfig;
    @Resource
    private SnowflakeIdWorker snowflakeIdWorker;

    @RequestMapping(value={""})
    public String index(ModelMap model) {
        model.put((Object)"config", (Object)this.systemConfigService.getConfigModelAll());
        model.put((Object)"fileSize", (Object)JsonUtil.objToJson((Object)this.cacheService.getAll()).getBytes(Charset.defaultCharset()).length);
        return "config/config";
    }

    @PostMapping(value={"/getAll"})
    @ResponseBody
    public RestResult getAll() {
        try {
            return RestResult.restSuccess((Object)"ok");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/upload"})
    @ResponseBody
    public RestResult upload(MultipartFile[] files) {
        try {
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i] == null) continue;
                    String filename = files[i].getOriginalFilename();
                    this.systemConfigService.checkFileSuffix(filename);
                    String tmpdir = System.getProperty("java.io.tmpdir");
                    File dest = new File(tmpdir + filename);
                    FileUtils.deleteQuietly((File)dest);
                    FileUtils.copyInputStreamToFile((InputStream)files[i].getInputStream(), (File)dest);
                    this.systemConfigService.refreshConfig(dest);
                    String msg = String.format("\u5bfc\u5165\u914d\u7f6e\u6587\u4ef6%s", filename);
                    this.logger.info(msg);
                    this.logService.log((LogType)LogType.CacheLog.IMPORT, msg);
                }
            }
            return RestResult.restSuccess((Object)"ok");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/download"})
    public void download(HttpServletResponse response) {
        String fileName = String.format("%s-%s-%s.json", this.appConfig.getName(), this.appConfig.getVersion(), this.snowflakeIdWorker.nextId());
        response.setHeader("content-type", "application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=%s", fileName));
        response.setContentType("application/octet-stream");
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            String cache = JsonUtil.objToJson((Object)this.cacheService.getAll());
            byte[] bytes = cache.getBytes(Charset.defaultCharset());
            int length = bytes.length;
            String msg = String.format("\u5bfc\u51fa\u914d\u7f6e\u6587\u4ef6%s\uff0c\u5927\u5c0f%dKB", fileName, length / 1024);
            this.logger.info(msg);
            this.logService.log((LogType)LogType.CacheLog.EXPORT, msg);
            outputStream.write(bytes, 0, length);
            outputStream.flush();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }
}

