/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.index;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.dbsyncer.biz.ConnectorService;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.web.controller.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/connector"})
public class ConnectorController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ConnectorService connectorService;

    @GetMapping(value={"/page/add"})
    public String pageAdd(HttpServletRequest request, ModelMap model) {
        model.put((Object)"connectorTypes", (Object)this.connectorService.getConnectorTypeAll());
        return "connector/add";
    }

    @GetMapping(value={"/page/add{page}"})
    public String page(HttpServletRequest request, ModelMap model, @PathVariable(value="page") String page) {
        return "connector/add" + page;
    }

    @GetMapping(value={"/page/edit"})
    public String pageEdit(HttpServletRequest request, ModelMap model, String id) {
        model.put((Object)"connector", (Object)this.connectorService.getConnector(id));
        return "connector/edit";
    }

    @PostMapping(value={"/copy"})
    @ResponseBody
    public RestResult add(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.connectorService.copy(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/add"})
    @ResponseBody
    public RestResult add(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.connectorService.add(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/edit"})
    @ResponseBody
    public RestResult edit(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.connectorService.edit(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/remove"})
    @ResponseBody
    public RestResult remove(HttpServletRequest request, @RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.connectorService.remove(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/get"})
    @ResponseBody
    public RestResult get(HttpServletRequest request, @RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.connectorService.getConnector(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/getAll"})
    @ResponseBody
    public RestResult getAll(HttpServletRequest request) {
        try {
            return RestResult.restSuccess((Object)this.connectorService.getConnectorAll());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }
}

