/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.index;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.dbsyncer.biz.ConnectorService;
import org.dbsyncer.biz.MappingService;
import org.dbsyncer.biz.ProjectGroupService;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.web.controller.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/projectGroup"})
public class ProjectGroupController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ProjectGroupService projectGroupService;
    @Resource
    private ConnectorService connectorService;
    @Resource
    private MappingService mappingService;

    @GetMapping(value={"/page/add"})
    public String pageAdd(ModelMap model) {
        model.put((Object)"connectors", (Object)this.connectorService.getConnectorAll());
        model.put((Object)"mappings", (Object)this.mappingService.getMappingAll());
        return "group/save";
    }

    @GetMapping(value={"/page/edit"})
    public String pageEdit(ModelMap model, String id) {
        model.put((Object)"projectGroup", (Object)this.projectGroupService.getProjectGroup(id));
        model.put((Object)"connectors", (Object)this.connectorService.getConnectorAll());
        model.put((Object)"mappings", (Object)this.mappingService.getMappingAll());
        return "group/save";
    }

    @PostMapping(value={"/add"})
    @ResponseBody
    public RestResult add(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.projectGroupService.add(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/edit"})
    @ResponseBody
    public RestResult edit(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.projectGroupService.edit(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/remove"})
    @ResponseBody
    public RestResult remove(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.projectGroupService.remove(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/getAll"})
    @ResponseBody
    public RestResult getAll() {
        try {
            return RestResult.restSuccess((Object)this.projectGroupService.getProjectGroupAll());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }
}

