/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.index;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.dbsyncer.biz.MappingService;
import org.dbsyncer.biz.TableGroupService;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.web.controller.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tableGroup"})
public class TableGroupController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private TableGroupService tableGroupService;
    @Resource
    private MappingService mappingService;

    @GetMapping(value={"/page/{page}"})
    public String page(ModelMap model, @PathVariable(value="page") String page, @RequestParam(value="id") String id) {
        TableGroup tableGroup = this.tableGroupService.getTableGroup(id);
        model.put((Object)"tableGroup", (Object)tableGroup);
        String mappingId = tableGroup.getMappingId();
        model.put((Object)"mapping", (Object)this.mappingService.getMapping(mappingId));
        this.initConfig(model);
        return "mapping/" + page;
    }

    @PostMapping(value={"/add"})
    @ResponseBody
    public RestResult add(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.tableGroupService.add(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/edit"})
    @ResponseBody
    public RestResult edit(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.tableGroupService.edit(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/refreshFields"})
    @ResponseBody
    public RestResult refreshFields(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.tableGroupService.refreshFields(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/remove"})
    @ResponseBody
    public RestResult remove(@RequestParam(value="mappingId") String mappingId, @RequestParam(value="ids") String ids) {
        try {
            return RestResult.restSuccess((Object)this.tableGroupService.remove(mappingId, ids));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/get"})
    @ResponseBody
    public RestResult get(@RequestParam(value="id") String id) {
        try {
            return RestResult.restSuccess((Object)this.tableGroupService.getTableGroup(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/getAll"})
    @ResponseBody
    public RestResult getAll(@RequestParam(value="mappingId") String mappingId) {
        try {
            return RestResult.restSuccess((Object)this.tableGroupService.getTableGroupAll(mappingId));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }
}

