/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.dbsyncer.biz.ConnectorService;
import org.dbsyncer.biz.DataSyncService;
import org.dbsyncer.biz.MonitorService;
import org.dbsyncer.biz.SystemConfigService;
import org.dbsyncer.biz.enums.DiskMetricEnum;
import org.dbsyncer.biz.enums.MetricEnum;
import org.dbsyncer.biz.enums.StatisticEnum;
import org.dbsyncer.biz.model.MetricResponse;
import org.dbsyncer.biz.model.Sample;
import org.dbsyncer.biz.vo.AppReportMetricVo;
import org.dbsyncer.biz.vo.HistoryStackVo;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.biz.vo.SystemConfigVo;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.DateFormatUtil;
import org.dbsyncer.manager.impl.PreloadTemplate;
import org.dbsyncer.web.controller.BaseController;
import org.dbsyncer.web.controller.monitor.HistoryStackValueFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.SystemHealth;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor"})
public class MonitorController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int COUNT = 24;
    private HistoryStackVo cpu = new HistoryStackVo();
    private HistoryStackVo memory = new HistoryStackVo();
    @Resource
    private MonitorService monitorService;
    @Resource
    private DataSyncService dataSyncService;
    @Resource
    private ConnectorService connectorService;
    @Resource
    private SystemConfigService systemConfigService;
    @Resource
    private PreloadTemplate preloadTemplate;
    @Resource
    private MetricsEndpoint metricsEndpoint;
    @Resource
    private HealthEndpoint healthEndpoint;
    @Resource
    private HistoryStackValueFormatter cpuHistoryStackValueFormatterImpl;
    @Resource
    private HistoryStackValueFormatter memoryHistoryStackValueFormatterImpl;

    @RequestMapping(value={""})
    public String index(HttpServletRequest request, ModelMap model) {
        Map<String, String> params = this.getParams(request);
        model.put((Object)"metaId", (Object)this.monitorService.getDefaultMetaId(params));
        model.put((Object)"meta", (Object)this.monitorService.getMetaAll());
        model.put((Object)"storageDataStatus", (Object)this.monitorService.getStorageDataStatusEnumAll());
        model.put((Object)"pagingData", (Object)this.monitorService.queryData(params));
        model.put((Object)"pagingLog", (Object)this.monitorService.queryLog(params));
        return "monitor/monitor.html";
    }

    @GetMapping(value={"/page/retry"})
    public String page(ModelMap model, String metaId, String messageId) {
        model.put((Object)"meta", (Object)this.monitorService.getMetaVo(metaId));
        model.put((Object)"message", (Object)this.dataSyncService.getMessageVo(metaId, messageId));
        return "monitor/retry.html";
    }

    @Scheduled(fixedRate=5000L)
    public void recordHistoryStackMetric() {
        this.recordHistoryStackMetric(MetricEnum.CPU_USAGE, this.cpu, this.cpuHistoryStackValueFormatterImpl);
        this.recordHistoryStackMetric(MetricEnum.MEMORY_USED, this.memory, this.memoryHistoryStackValueFormatterImpl);
    }

    @Scheduled(fixedRate=10000L)
    public void refreshConnectorHealth() {
        if (this.preloadTemplate.isPreloadCompleted()) {
            this.connectorService.refreshHealth();
        }
    }

    @Scheduled(fixedRate=30000L)
    public void deleteExpiredDataAndLog() {
        if (this.preloadTemplate.isPreloadCompleted()) {
            this.monitorService.deleteExpiredDataAndLog();
        }
    }

    @GetMapping(value={"/queryData"})
    @ResponseBody
    public RestResult queryData(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.monitorService.queryData(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/queryLog"})
    @ResponseBody
    public RestResult queryLog(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.monitorService.queryLog(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/sync"})
    @ResponseBody
    public RestResult sync(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.dataSyncService.sync(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/clearData"})
    @ResponseBody
    public RestResult clearData(String id) {
        try {
            return RestResult.restSuccess((Object)this.monitorService.clearData(id));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/clearLog"})
    @ResponseBody
    public RestResult clearLog() {
        try {
            return RestResult.restSuccess((Object)this.monitorService.clearLog());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @ResponseBody
    @GetMapping(value={"/queryAppReportMetric"})
    public RestResult queryAppReportMetric() {
        try {
            ArrayList<MetricResponse> list = new ArrayList<MetricResponse>();
            List metricEnumList = this.monitorService.getMetricEnumAll();
            if (!CollectionUtils.isEmpty((Collection)metricEnumList)) {
                metricEnumList.forEach(m -> list.add(this.getMetricResponse(m.getCode())));
            }
            list.addAll(this.getDiskHealth());
            AppReportMetricVo reportMetric = this.monitorService.queryAppReportMetric(list);
            reportMetric.setCpu(this.cpu);
            reportMetric.setMemory(this.memory);
            return RestResult.restSuccess((Object)reportMetric);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @ResponseBody
    @GetMapping(value={"/getRefreshIntervalSeconds"})
    public RestResult getRefreshInterval() {
        try {
            SystemConfigVo config = this.systemConfigService.getSystemConfigVo();
            return RestResult.restSuccess((Object)config.getRefreshIntervalSeconds());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    private List<MetricResponse> getDiskHealth() {
        ArrayList<MetricResponse> list = new ArrayList<MetricResponse>();
        SystemHealth health = (SystemHealth)this.healthEndpoint.health();
        Map details = health.getComponents();
        Health diskSpace = (Health)details.get("diskSpace");
        Map diskSpaceDetails = diskSpace.getDetails();
        list.add(this.createDiskMetricResponse(DiskMetricEnum.THRESHOLD, diskSpaceDetails.get("threshold")));
        list.add(this.createDiskMetricResponse(DiskMetricEnum.FREE, diskSpaceDetails.get("free")));
        list.add(this.createDiskMetricResponse(DiskMetricEnum.TOTAL, diskSpaceDetails.get("total")));
        return list;
    }

    private MetricResponse createDiskMetricResponse(DiskMetricEnum metricEnum, Object value) {
        return new MetricResponse(metricEnum.getCode(), metricEnum.getGroup(), metricEnum.getMetricName(), Arrays.asList(new Sample(StatisticEnum.COUNT.getTagValueRepresentation(), value)));
    }

    private MetricResponse getMetricResponse(String code) {
        MetricsEndpoint.MetricResponse metric = this.metricsEndpoint.metric(code, null);
        MetricResponse metricResponse = new MetricResponse();
        MetricEnum metricEnum = MetricEnum.getMetric((String)metric.getName());
        metricResponse.setCode(metricEnum.getCode());
        metricResponse.setGroup(metricEnum.getGroup());
        metricResponse.setMetricName(metricEnum.getMetricName());
        if (!CollectionUtils.isEmpty((Collection)metric.getMeasurements())) {
            ArrayList measurements = new ArrayList();
            metric.getMeasurements().forEach(s -> measurements.add(new Sample(s.getStatistic().getTagValueRepresentation(), (Object)s.getValue())));
            metricResponse.setMeasurements(measurements);
        }
        return metricResponse;
    }

    private void recordHistoryStackMetric(MetricEnum metricEnum, HistoryStackVo stackVo, HistoryStackValueFormatter formatter) {
        MetricResponse metricResponse = this.getMetricResponse(metricEnum.getCode());
        List measurements = metricResponse.getMeasurements();
        if (!CollectionUtils.isEmpty((Collection)measurements)) {
            this.addHistoryStack(stackVo.getValue(), formatter.formatValue(((Sample)measurements.get(0)).getValue()));
            this.addHistoryStack(stackVo.getName(), DateFormatUtil.getCurrentTime());
        }
    }

    private void addHistoryStack(List<Object> stack, Object value) {
        if (stack.size() >= 24) {
            stack.remove(0);
        }
        stack.add(value);
    }
}

