/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.openapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.common.util.RandomUtil;
import org.dbsyncer.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.support.RequestContextUtils;

@Controller
@RequestMapping(value={"/gateway"})
public class OpenApiController
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    @Resource
    private ApplicationContext applicationContext;
    private Map<String, String> parsePackage = new HashMap<String, String>();
    private Map<String, InvocableHandlerMethod> handlers = new ConcurrentHashMap<String, InvocableHandlerMethod>();
    private HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    @ResponseBody
    @RequestMapping(value={"/demo.json"})
    public RestResult demo(Long id, String version) {
        this.logger.info("id:{},version:{}", (Object)id, (Object)version);
        return RestResult.restSuccess((Object)RandomUtil.nextInt((int)1, (int)100));
    }

    @ResponseBody
    @RequestMapping(value={"/api.json"})
    public Object adapter(HttpServletRequest request, HttpServletResponse response) {
        try {
            InvocableHandlerMethod invocableMethod = this.handlers.get("/gateway/demo.json");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", 1000L);
            params.put("version", "20201124");
            ArrayList providedArgs = new ArrayList();
            Object[] parameterNames = this.parameterNameDiscoverer.getParameterNames(invocableMethod.getMethod());
            this.logger.info(Arrays.toString(parameterNames));
            if (!ObjectUtils.isEmpty((Object[])parameterNames)) {
                int length = parameterNames.length;
                for (int i = 0; i < length; ++i) {
                    providedArgs.add(params.get(parameterNames[i]));
                }
            }
            ServletWebRequest webRequest = new ServletWebRequest(request, response);
            ModelAndViewContainer mavContainer = new ModelAndViewContainer();
            mavContainer.addAllAttributes(RequestContextUtils.getInputFlashMap((HttpServletRequest)request));
            Object invoke = invocableMethod.invokeForRequest((NativeWebRequest)webRequest, mavContainer, providedArgs.toArray());
            return invoke;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public void afterPropertiesSet() {
        this.initHandlerMapping();
        this.resolvers.addResolvers(this.requestMappingHandlerAdapter.getArgumentResolvers());
    }

    private void initHandlerMapping() {
        this.parsePackage.put("/gateway/", "");
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        Map map = mapping.getHandlerMethods();
        map.forEach((k, v) -> {
            PatternsRequestCondition condition = k.getPatternsCondition();
            Object[] array = condition.getPatterns().toArray();
            int length = array.length;
            for (Map.Entry<String, String> obj : this.parsePackage.entrySet()) {
                boolean filter = false;
                for (int i = 0; i < length; ++i) {
                    if (!StringUtil.startsWith((CharSequence)((String)array[i]), (CharSequence)obj.getKey())) continue;
                    Object bean = this.applicationContext.getBean(v.getBeanType());
                    InvocableHandlerMethod invocableHandlerMethod = new InvocableHandlerMethod(bean, v.getMethod());
                    invocableHandlerMethod.setHandlerMethodArgumentResolvers(this.resolvers);
                    this.handlers.putIfAbsent((String)array[i], invocableHandlerMethod);
                    filter = true;
                    break;
                }
                if (!filter) continue;
                break;
            }
        });
    }
}

