/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.dbsyncer.biz.PluginService;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.common.config.AppConfig;
import org.dbsyncer.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/plugin"})
public class PluginController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private PluginService pluginService;
    @Resource
    private AppConfig appConfig;

    @RequestMapping(value={""})
    public String index(ModelMap model) {
        model.put((Object)"plugins", (Object)this.pluginService.getPluginAll());
        model.put((Object)"version", (Object)this.appConfig.getVersion());
        return "plugin/plugin";
    }

    @PostMapping(value={"/upload"})
    @ResponseBody
    public RestResult upload(MultipartFile[] files) {
        try {
            if (files != null && files.length > 0) {
                MultipartFile file = null;
                String filePath = this.pluginService.getPluginPath();
                FileUtils.forceMkdir((File)new File(filePath));
                for (int i = 0; i < files.length; ++i) {
                    file = files[i];
                    if (file == null) continue;
                    String filename = file.getOriginalFilename();
                    this.pluginService.checkFileSuffix(filename);
                    File dest = new File(filePath + filename);
                    FileUtils.deleteQuietly((File)dest);
                    FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)dest);
                }
                this.pluginService.loadPlugins();
            }
            return RestResult.restSuccess((Object)"ok");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/download"})
    public void download(HttpServletResponse response, String name) {
        block7: {
            String fileName = String.format("dbsyncer-%s-%s.jar", name, this.appConfig.getVersion());
            File file = new File(this.pluginService.getLibraryPath() + fileName);
            if (!file.exists()) {
                this.write(response, RestResult.restFail((Object)"Could not find file", (int)404));
                return;
            }
            response.setHeader("content-type", "application/octet-stream");
            response.setHeader("Content-Disposition", String.format("attachment; filename=%s", fileName));
            response.setContentType("application/octet-stream");
            BufferedInputStream bis = null;
            ServletOutputStream outputStream = null;
            try {
                outputStream = response.getOutputStream();
                bis = new BufferedInputStream(new FileInputStream(file));
                byte[] buff = new byte[2048];
                int read = bis.read(buff);
                while (read != -1) {
                    outputStream.write(buff, 0, buff.length);
                    outputStream.flush();
                    read = bis.read(buff);
                }
                IOUtils.closeQuietly((InputStream)bis);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
                break block7;
            }
            finally {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HttpServletResponse response, RestResult result) {
        PrintWriter out = null;
        try {
            response.setContentType("application/json;charset=utf-8");
            response.setStatus(result.getStatus());
            out = response.getWriter();
            out.write(JsonUtil.objToJson((Object)result));
            out.flush();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }
}

