/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.system;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.dbsyncer.biz.SystemConfigService;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.web.controller.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system"})
public class SystemController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SystemConfigService systemConfigService;

    @RequestMapping(value={""})
    public String index(ModelMap model) {
        model.put((Object)"config", (Object)this.systemConfigService.getSystemConfigVo());
        return "system/system";
    }

    @PostMapping(value={"/edit"})
    @ResponseBody
    public RestResult edit(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParams(request);
            return RestResult.restSuccess((Object)this.systemConfigService.edit(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/queryConfig"})
    @ResponseBody
    public RestResult queryConfig() {
        try {
            return RestResult.restSuccess((Object)this.systemConfigService.getSystemConfigVo());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), e.getClass());
            return RestResult.restFail((Object)e.getMessage());
        }
    }
}

