/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.web.controller.user;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.dbsyncer.biz.UserConfigService;
import org.dbsyncer.biz.vo.RestResult;
import org.dbsyncer.biz.vo.UserInfoVo;
import org.dbsyncer.web.controller.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private UserConfigService userConfigService;

    @RequestMapping(value={""})
    public String index(ModelMap model) {
        model.put((Object)"currentUser", (Object)this.getUserInfoVo());
        model.put((Object)"users", (Object)this.userConfigService.getUserInfoAll(this.getUserName()));
        return "user/user";
    }

    @GetMapping(value={"/page/add"})
    public String pageAdd(ModelMap model) {
        return "user/add";
    }

    @GetMapping(value={"/page/edit"})
    public String pageEdit(ModelMap model, String username) {
        String currentUserName = this.getUserName();
        model.put((Object)"currentUserName", (Object)currentUserName);
        model.put((Object)"currentUser", (Object)this.userConfigService.getUserInfoVo(currentUserName, username));
        return "user/edit";
    }

    @GetMapping(value={"/getUserInfo.json"})
    @ResponseBody
    public RestResult getUserInfo() {
        return RestResult.restSuccess((Object)this.getUserInfoVo());
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public RestResult add(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParamsWithUserName(request);
            return RestResult.restSuccess((Object)this.userConfigService.add(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/edit"})
    @ResponseBody
    public RestResult edit(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParamsWithUserName(request);
            return RestResult.restSuccess((Object)this.userConfigService.edit(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/remove"})
    @ResponseBody
    public RestResult remove(HttpServletRequest request) {
        try {
            Map<String, String> params = this.getParamsWithUserName(request);
            return RestResult.restSuccess((Object)this.userConfigService.remove(params));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return RestResult.restFail((Object)e.getMessage());
        }
    }

    private Map<String, String> getParamsWithUserName(HttpServletRequest request) {
        Map<String, String> params = this.getParams(request);
        params.put("currentUserName", this.getUserName());
        return params;
    }

    private UserInfoVo getUserInfoVo() {
        String currentUserName = this.getUserName();
        return this.userConfigService.getUserInfoVo(currentUserName, currentUserName);
    }

    private String getUserName() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String username = authentication.getName();
        Assert.hasText((String)username, (String)"\u65e0\u6cd5\u83b7\u53d6\u767b\u5f55\u7528\u6237.");
        return username;
    }
}

