/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.sqlite;

import java.util.List;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.sqlite.validator.DqlSQLiteConfigValidator;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.database.AbstractDQLConnector;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.listener.DatabaseQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.PageSql;

public final class DqlSQLiteConnector
extends AbstractDQLConnector {
    private final String TYPE = "DqlSQLite";
    private final DqlSQLiteConfigValidator configValidator = new DqlSQLiteConfigValidator();

    public String getConnectorType() {
        return "DqlSQLite";
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new DatabaseQuartzListener();
        }
        return null;
    }

    public String getPageSql(PageSql config) {
        List primaryKeys = config.getPrimaryKeys();
        String orderBy = StringUtil.join((Iterable)primaryKeys, (String)",");
        return String.format(" limit ? OFFSET ?", orderBy, config.getQuerySql());
    }

    public Object[] getPageArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        int pageIndex = config.getPageIndex();
        return new Object[]{(pageIndex - 1) * pageSize + 1, pageIndex * pageSize};
    }
}

