/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.sqlite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.connector.sqlite.validator.SQLiteConfigValidator;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.database.AbstractDatabaseConnector;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.enums.TableTypeEnum;
import org.dbsyncer.sdk.listener.DatabaseQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.PageSql;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;

public final class SQLiteConnector
extends AbstractDatabaseConnector {
    private final String QUERY_VIEW = "SELECT name FROM sqlite_master WHERE type = 'view'";
    private final String QUERY_TABLE = "SELECT name FROM sqlite_master WHERE type='table'";
    private final String TYPE = "SQLite";
    private final SQLiteConfigValidator configValidator = new SQLiteConfigValidator();

    public String getConnectorType() {
        return "SQLite";
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public List<Table> getTable(DatabaseConnectorInstance connectorInstance) {
        DatabaseConfig config = connectorInstance.getConfig();
        List<Table> tables = this.getTables(connectorInstance, String.format("SELECT name FROM sqlite_master WHERE type='table'", config.getSchema()), TableTypeEnum.TABLE);
        tables.addAll(this.getTables(connectorInstance, "SELECT name FROM sqlite_master WHERE type = 'view'", TableTypeEnum.VIEW));
        return tables;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new DatabaseQuartzListener();
        }
        return null;
    }

    public String getPageSql(PageSql config) {
        StringBuilder sql = new StringBuilder(config.getQuerySql());
        if (PrimaryKeyUtil.isSupportedCursor((List)config.getFields())) {
            this.appendOrderByPk(config, sql);
        }
        sql.append(" limit ? OFFSET ?");
        return sql.toString();
    }

    public Object[] getPageArgs(ReaderConfig config) {
        int pageIndex = config.getPageIndex();
        int pageSize = config.getPageSize();
        return new Object[]{pageSize, (pageIndex - 1) * pageSize};
    }

    public String buildTableName(String tableName) {
        return this.convertKey(tableName);
    }

    public String buildFieldName(Field field) {
        return this.convertKey(field.getName());
    }

    public List<String> buildPrimaryKeys(List<String> primaryKeys) {
        if (CollectionUtils.isEmpty(primaryKeys)) {
            return primaryKeys;
        }
        return primaryKeys.stream().map(pk -> this.convertKey((String)pk)).collect(Collectors.toList());
    }

    private List<Table> getTables(DatabaseConnectorInstance connectorInstance, String sql, TableTypeEnum type) {
        List tableNames = (List)connectorInstance.execute(databaseTemplate -> databaseTemplate.queryForList(sql, String.class));
        if (!CollectionUtils.isEmpty((Collection)tableNames)) {
            return tableNames.stream().map(name -> new Table(name, type.getCode())).collect(Collectors.toList());
        }
        return new ArrayList<Table>();
    }

    private String convertKey(String key) {
        return "\"" + key + "\"";
    }
}

