/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.util.function.BiFunction;

class JSONPathTypedMulti
extends JSONPath {
    final JSONPath[] paths;
    final Type[] types;
    final String[] formats;
    final long[] pathFeatures;
    final ZoneId zoneId;

    protected JSONPathTypedMulti(JSONPath[] paths, Type[] types, String[] formats, long[] pathFeatures, ZoneId zoneId, long features) {
        super(JSON.toJSONString(paths), features);
        this.types = types;
        this.paths = paths;
        this.formats = formats;
        this.pathFeatures = pathFeatures;
        this.zoneId = zoneId;
    }

    @Override
    public boolean isRef() {
        for (JSONPath jsonPath : this.paths) {
            if (jsonPath.isRef()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        for (JSONPath jsonPath : this.paths) {
            if (!jsonPath.contains(object)) continue;
            return true;
        }
        return false;
    }

    protected boolean isIgnoreError(int index) {
        if (this.pathFeatures != null && index < this.pathFeatures.length) {
            long features = this.pathFeatures[index];
            return (features & JSONPath.Feature.NullOnError.mask) != 0L;
        }
        return false;
    }

    @Override
    public Object eval(Object object) {
        Object[] array = new Object[this.paths.length];
        for (int i = 0; i < this.paths.length; ++i) {
            JSONPath jsonPath = this.paths[i];
            Object result = jsonPath.eval(object);
            try {
                array[i] = TypeUtils.cast(result, this.types[i]);
                continue;
            }
            catch (Exception e) {
                if (this.isIgnoreError(i)) continue;
                throw new JSONException("jsonpath eval path, path : " + jsonPath + ", msg : " + e.getMessage(), e);
            }
        }
        return array;
    }

    @Override
    protected JSONReader.Context createContext() {
        JSONReader.Context context = JSONFactory.createReadContext();
        if (this.zoneId != null && this.zoneId != DateUtils.DEFAULT_ZONE_ID) {
            context.zoneId = this.zoneId;
        }
        return context;
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        Object object = jsonReader.readAny();
        return this.eval(object);
    }

    @Override
    public String extractScalar(JSONReader jsonReader) {
        Object object = this.extract(jsonReader);
        return JSON.toJSONString(object);
    }

    @Override
    public void set(Object object, Object value) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void set(Object object, Object value, JSONReader.Feature ... readerFeatures) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void setCallback(Object object, BiFunction callback) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void setInt(Object object, int value) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void setLong(Object object, long value) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public boolean remove(Object object) {
        throw new JSONException("unsupported operation");
    }
}

