/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplBoolean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;

abstract class FieldWriterBoolean
extends FieldWriter {
    volatile byte[] utf8ValueTrue;
    volatile byte[] utf8ValueFalse;
    volatile char[] utf16ValueTrue;
    volatile char[] utf16ValueFalse;

    FieldWriterBoolean(String name, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field, Method method) {
        super(name, ordinal, features, format, label, fieldType, fieldClass, field, method);
    }

    public void writeValue(JSONWriter jsonWriter, Object object) {
        Boolean value = (Boolean)this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeBool(value);
    }

    @Override
    public void writeBool(JSONWriter jsonWriter, boolean value) {
        boolean writeNonStringValueAsString;
        boolean bl = writeNonStringValueAsString = (jsonWriter.getFeatures() & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        if (writeNonStringValueAsString) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(value ? "true" : "false");
            return;
        }
        if (jsonWriter.utf8) {
            if (value) {
                if (this.utf8ValueTrue == null) {
                    byte[] bytes = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + 4);
                    bytes[this.nameWithColonUTF8.length] = 116;
                    bytes[this.nameWithColonUTF8.length + 1] = 114;
                    bytes[this.nameWithColonUTF8.length + 2] = 117;
                    bytes[this.nameWithColonUTF8.length + 3] = 101;
                    this.utf8ValueTrue = bytes;
                }
                jsonWriter.writeNameRaw(this.utf8ValueTrue);
            } else {
                if (this.utf8ValueFalse == null) {
                    byte[] bytes = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + 5);
                    bytes[this.nameWithColonUTF8.length] = 102;
                    bytes[this.nameWithColonUTF8.length + 1] = 97;
                    bytes[this.nameWithColonUTF8.length + 2] = 108;
                    bytes[this.nameWithColonUTF8.length + 3] = 115;
                    bytes[this.nameWithColonUTF8.length + 4] = 101;
                    this.utf8ValueFalse = bytes;
                }
                jsonWriter.writeNameRaw(this.utf8ValueFalse);
            }
            return;
        }
        if (jsonWriter.utf16) {
            if (value) {
                if (this.utf16ValueTrue == null) {
                    char[] chars = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + 4);
                    chars[this.nameWithColonUTF16.length] = 116;
                    chars[this.nameWithColonUTF16.length + 1] = 114;
                    chars[this.nameWithColonUTF16.length + 2] = 117;
                    chars[this.nameWithColonUTF16.length + 3] = 101;
                    this.utf16ValueTrue = chars;
                }
                jsonWriter.writeNameRaw(this.utf16ValueTrue);
            } else {
                if (this.utf16ValueFalse == null) {
                    char[] chars = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + 5);
                    chars[this.nameWithColonUTF16.length] = 102;
                    chars[this.nameWithColonUTF16.length + 1] = 97;
                    chars[this.nameWithColonUTF16.length + 2] = 108;
                    chars[this.nameWithColonUTF16.length + 3] = 115;
                    chars[this.nameWithColonUTF16.length + 4] = 101;
                    this.utf16ValueFalse = chars;
                }
                jsonWriter.writeNameRaw(this.utf16ValueFalse);
            }
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeBool(value);
    }

    public boolean write(JSONWriter jsonWriter, Object object) {
        Boolean value;
        try {
            value = (Boolean)this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullBooleanAsFalse.mask)) == 0L) {
                return false;
            }
            this.writeFieldName(jsonWriter);
            jsonWriter.writeBooleanNull();
            return true;
        }
        this.writeBool(jsonWriter, value);
        return true;
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        return ObjectWriterImplBoolean.INSTANCE;
    }
}

