/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle.cdc;

import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;
import org.dbsyncer.common.QueueOverflowException;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.oracle.OracleException;
import org.dbsyncer.connector.oracle.logminer.LogMiner;
import org.dbsyncer.connector.oracle.logminer.RedoEvent;
import org.dbsyncer.connector.oracle.logminer.parser.impl.DeleteSql;
import org.dbsyncer.connector.oracle.logminer.parser.impl.InsertSql;
import org.dbsyncer.connector.oracle.logminer.parser.impl.UpdateSql;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.listener.AbstractDatabaseListener;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.event.DDLChangedEvent;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.dbsyncer.sdk.model.ChangedOffset;
import org.dbsyncer.sdk.model.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleListener
extends AbstractDatabaseListener {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String REDO_POSITION = "position";
    private final Map<String, List<Field>> tableFiledMap = new ConcurrentHashMap<String, List<Field>>();
    private LogMiner logMiner;

    public void init() {
        this.sourceTable.forEach(table -> this.tableFiledMap.put(table.getName(), table.getColumn()));
    }

    public void start() {
        try {
            DatabaseConfig config = ((DatabaseConnectorInstance)this.getConnectorInstance()).getConfig();
            String driverClassName = config.getDriverClassName();
            String username = config.getUsername();
            String password = config.getPassword();
            String url = config.getUrl();
            String schema = config.getSchema();
            boolean containsPos = this.snapshot.containsKey("position");
            this.logMiner = new LogMiner(username, password, url, schema, driverClassName);
            this.logMiner.setStartScn(containsPos ? Long.parseLong((String)this.snapshot.get("position")) : 0L);
            this.logMiner.registerEventListener(event -> {
                try {
                    this.parseEvent(event);
                }
                catch (JSQLParserException e) {
                    this.logger.error("\u4e0d\u652f\u6301sql:{}", (Object)event.getRedoSql());
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            });
            this.logMiner.start();
        }
        catch (Exception e) {
            this.logger.error("\u542f\u52a8\u5931\u8d25:{}", (Object)e.getMessage());
            throw new OracleException(e);
        }
    }

    private void trySendEvent(ChangedEvent event) {
        try {
            long now = Instant.now().toEpochMilli();
            boolean isReTry = false;
            while (this.logMiner.isConnected()) {
                try {
                    this.sendChangedEvent(event);
                    break;
                }
                catch (QueueOverflowException e) {
                    isReTry = true;
                    try {
                        TimeUnit.MILLISECONDS.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        this.logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            if (isReTry) {
                this.logger.info("\u91cd\u8bd5\u8017\u65f6\uff1a{}ms", (Object)(Instant.now().toEpochMilli() - now));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void parseEvent(RedoEvent event) throws Exception {
        Alter alter;
        Delete delete;
        String tableName;
        Statement statement = CCJSqlParserUtil.parse((String)event.getRedoSql());
        if (statement instanceof Update) {
            Update update = (Update)statement;
            String tableName2 = this.getTableName(update.getTable());
            if (this.tableFiledMap.containsKey(tableName2)) {
                UpdateSql parser = new UpdateSql(update, this.tableFiledMap.get(tableName2));
                this.trySendEvent((ChangedEvent)new RowChangedEvent(tableName2, "UPDATE", parser.parseColumns(), null, (Object)event.getScn()));
            }
            return;
        }
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            String tableName3 = this.getTableName(insert.getTable());
            if (this.tableFiledMap.containsKey(tableName3)) {
                InsertSql parser = new InsertSql(insert, this.tableFiledMap.get(tableName3));
                this.trySendEvent((ChangedEvent)new RowChangedEvent(tableName3, "INSERT", parser.parseColumns(), null, (Object)event.getScn()));
            }
            return;
        }
        if (statement instanceof Delete && this.tableFiledMap.containsKey(tableName = this.getTableName((delete = (Delete)statement).getTable()))) {
            DeleteSql parser = new DeleteSql(delete, this.tableFiledMap.get(tableName));
            this.trySendEvent((ChangedEvent)new RowChangedEvent(tableName, "DELETE", parser.parseColumns(), null, (Object)event.getScn()));
        }
        if (statement instanceof Alter && this.tableFiledMap.containsKey(tableName = this.getTableName((alter = (Alter)statement).getTable()))) {
            this.logger.info("sql:{}", (Object)event.getRedoSql());
            this.trySendEvent((ChangedEvent)new DDLChangedEvent(null, tableName, "ALTER", event.getRedoSql(), null, (Object)event.getScn()));
        }
    }

    public void close() {
        try {
            if (this.logMiner != null) {
                this.logMiner.close();
            }
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void refreshEvent(ChangedOffset offset) {
        this.snapshot.put("position", String.valueOf(offset.getPosition()));
    }

    private String getTableName(Table table) {
        return table == null ? "" : StringUtil.replace((String)table.getName(), (String)"\"", (String)"");
    }
}

