/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle.logminer;

import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.oracle.logminer.LogFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerHelper.class);
    public static final int LOG_MINER_OC_INSERT = 1;
    public static final int LOG_MINER_OC_DELETE = 2;
    public static final int LOG_MINER_OC_UPDATE = 3;
    public static final int LOG_MINER_OC_DDL = 5;
    public static final int LOG_MINER_OC_COMMIT = 7;
    public static final int LOG_MINER_OC_MISSING_SCN = 34;
    public static final int LOG_MINER_OC_ROLLBACK = 36;

    public static void removeLogFilesFromMining(Connection conn) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("SELECT FILENAME AS NAME FROM V$LOGMNR_LOGS");
             ResultSet result = ps.executeQuery();){
            LinkedHashSet<String> files = new LinkedHashSet<String>();
            while (result.next()) {
                files.add(result.getString(1));
            }
            for (String fileName : files) {
                String sql = String.format("BEGIN SYS.DBMS_LOGMNR.REMOVE_LOGFILE(LOGFILENAME => '%s');END;", fileName);
                LogMinerHelper.executeCallableStatement(conn, sql);
                LOGGER.debug("File {} was removed from mining", (Object)fileName);
            }
        }
    }

    public static void executeCallableStatement(Connection connection, String statement) throws SQLException {
        Objects.requireNonNull(statement);
        try (CallableStatement s = connection.prepareCall(statement);){
            s.execute();
        }
    }

    public static List<LogFile> getOnlineLogFilesForOffsetScn(Connection connection, BigInteger offsetScn) throws SQLException {
        ArrayList<LogFile> redoLogFiles = new ArrayList<LogFile>();
        String onlineLogQuery = "SELECT MIN(F.MEMBER) AS FILE_NAME, L.NEXT_CHANGE# AS NEXT_CHANGE, F.GROUP#, L.FIRST_CHANGE# AS FIRST_CHANGE, L.STATUS  FROM V$LOG L, V$LOGFILE F  WHERE F.GROUP# = L.GROUP# AND L.NEXT_CHANGE# > 0  GROUP BY F.GROUP#, L.NEXT_CHANGE#, L.FIRST_CHANGE#, L.STATUS ORDER BY 3";
        try (PreparedStatement s = connection.prepareStatement(onlineLogQuery);
             ResultSet rs = s.executeQuery();){
            while (rs.next()) {
                String status;
                String fileName = rs.getString(1);
                BigInteger nextChangeNumber = new BigInteger(rs.getString(2));
                BigInteger firstChangeNumber = new BigInteger(rs.getString(4));
                LogFile logFile = new LogFile(fileName, firstChangeNumber, nextChangeNumber, "CURRENT".equalsIgnoreCase(status = rs.getString(5)));
                if (!logFile.isCurrent() && logFile.getNextScn().compareTo(offsetScn) < 0) continue;
                redoLogFiles.add(logFile);
            }
        }
        return redoLogFiles;
    }

    public static List<LogFile> getArchivedLogFilesForOffsetScn(Connection connection, BigInteger offsetScn) throws SQLException {
        String archiveLogsQuery = String.format("SELECT NAME AS FILE_NAME, NEXT_CHANGE# AS NEXT_CHANGE, FIRST_CHANGE# AS FIRST_CHANGE FROM V$ARCHIVED_LOG WHERE NAME IS NOT NULL AND ARCHIVED = 'YES' AND STATUS = 'A' AND NEXT_CHANGE# > %s ORDER BY 2", offsetScn);
        ArrayList<LogFile> archiveLogFiles = new ArrayList<LogFile>();
        try (PreparedStatement s = connection.prepareStatement(archiveLogsQuery);
             ResultSet rs = s.executeQuery();){
            while (rs.next()) {
                String fileName = rs.getString(1);
                BigInteger firstChangeNumber = new BigInteger(rs.getString(3));
                BigInteger nextChangeNumber = new BigInteger(rs.getString(2));
                archiveLogFiles.add(new LogFile(fileName, firstChangeNumber, nextChangeNumber, false));
            }
        }
        return archiveLogFiles;
    }

    public static void addLogFile(Connection connection, String fileName) throws SQLException {
        String addLogFile = "BEGIN sys.dbms_logmnr.add_logfile(LOGFILENAME => '%s', OPTIONS => %s);END;";
        String options = "DBMS_LOGMNR.ADDFILE";
        LogMinerHelper.executeCallableStatement(connection, String.format(addLogFile, fileName, options));
    }

    /*
     * Exception decompiling
     */
    public static List<BigInteger> getCurrentRedoLogSequences(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void buildDataDictionary(Connection connection, String miningStrategy) throws SQLException {
        if (StringUtil.isBlank((CharSequence)miningStrategy)) {
            String sql = "BEGIN DBMS_LOGMNR_D.BUILD (options => DBMS_LOGMNR_D.STORE_IN_REDO_LOGS); END;";
            LogMinerHelper.executeCallableStatement(connection, sql);
        }
    }

    public static void startLogMiner(Connection connection, BigInteger startScn, BigInteger endScn, String miningStrategy) throws SQLException {
        LOGGER.debug("startLogMiner... startScn {}, endScn {}", (Object)startScn, (Object)endScn);
        if (StringUtil.isBlank((CharSequence)miningStrategy)) {
            miningStrategy = "DBMS_LOGMNR.DICT_FROM_REDO_LOGS + DBMS_LOGMNR.DDL_DICT_TRACKING ";
        }
        String startLogMiner = "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '" + startScn + "', endScn => '" + endScn + "', OPTIONS => " + miningStrategy + " + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        LogMinerHelper.executeCallableStatement(connection, startLogMiner);
    }

    public static void endLogMiner(Connection connection) {
        try {
            LogMinerHelper.executeCallableStatement(connection, "BEGIN SYS.DBMS_LOGMNR.END_LOGMNR(); END;");
        }
        catch (SQLException e) {
            if (e.getMessage().toUpperCase().contains("ORA-01307")) {
                LOGGER.info("LogMiner session was already closed");
            }
            LOGGER.error("Cannot close LogMiner session gracefully: {}", (Throwable)e);
        }
    }

    public static String logMinerViewQuery(String schema, String logMinerUser) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * ");
        query.append("FROM V$LOGMNR_CONTENTS ");
        query.append("WHERE ");
        query.append("SCN >= ? AND SCN < ? ");
        query.append("AND (");
        query.append("(OPERATION_CODE IN (5,34) AND USERNAME NOT IN (").append(LogMinerHelper.getExcludedUsers(logMinerUser)).append(")) ");
        query.append("OR (OPERATION_CODE IN (7,36)) ");
        query.append("OR ");
        query.append("(OPERATION_CODE IN (1,2,3) ");
        query.append(" AND SEG_OWNER NOT IN ('APPQOSSYS','AUDSYS','CTXSYS','DVSYS','DBSFWUSER','DBSNMP','GSMADMIN_INTERNAL','LBACSYS','MDSYS','OJVMSYS','OLAPSYS','ORDDATA','ORDSYS','OUTLN','SYS','SYSTEM','WMSYS','XDB') ");
        if (StringUtil.isNotBlank((CharSequence)schema)) {
            query.append(String.format(" AND (REGEXP_LIKE(SEG_OWNER,'^%s$','i')) ", schema));
        }
        query.append(" ))");
        return query.toString();
    }

    private static String getExcludedUsers(String logMinerUser) {
        return "'SYS','SYSTEM','" + logMinerUser.toUpperCase() + "'";
    }

    public static void setSessionParameter(Connection connection) throws SQLException {
        String sql = "ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'";
        LogMinerHelper.executeCallableStatement(connection, sql);
        LogMinerHelper.executeCallableStatement(connection, "ALTER SESSION SET TIME_ZONE = '00:00'");
    }
}

