/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle.logminer;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalBuffer {
    private final Logger LOGGER = LoggerFactory.getLogger(TransactionalBuffer.class);
    private final Map<String, Transaction> transactions = new HashMap<String, Transaction>();
    private BigInteger lastCommittedScn = BigInteger.ZERO;

    public boolean isEmpty() {
        return this.transactions.isEmpty();
    }

    private BigInteger calculateSmallestScn() {
        return this.transactions.isEmpty() ? null : this.transactions.values().stream().map(transaction -> ((Transaction)transaction).firstScn).min(BigInteger::compareTo).orElseThrow(() -> new RuntimeException("Cannot calculate smallest SCN"));
    }

    public void registerCommitCallback(String transactionId, BigInteger scn, CommitCallback callback) {
        this.transactions.computeIfAbsent(transactionId, s -> new Transaction(scn));
        Transaction transaction = this.transactions.get(transactionId);
        if (transaction != null) {
            transaction.commitCallbacks.add(callback);
        }
    }

    public boolean commit(String txId, BigInteger commitScn, long committedScn) {
        Transaction transaction = this.transactions.remove(txId);
        if (transaction == null) {
            return false;
        }
        BigInteger smallestScn = this.calculateSmallestScn();
        if (committedScn > commitScn.longValue() || this.lastCommittedScn.longValue() > commitScn.longValue()) {
            this.LOGGER.warn("txId {} already commit, ignore.", (Object)txId);
            return false;
        }
        int counter = transaction.commitCallbacks.size();
        for (CommitCallback callback : transaction.commitCallbacks) {
            try {
                callback.execute(smallestScn, commitScn, --counter);
            }
            catch (InterruptedException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        this.lastCommittedScn = commitScn;
        return true;
    }

    public boolean rollback(String txId) {
        return this.transactions.remove(txId) != null;
    }

    private final class Transaction {
        private final BigInteger firstScn;
        private BigInteger lastScn;
        private final List<CommitCallback> commitCallbacks;

        private Transaction(BigInteger firstScn) {
            this.firstScn = firstScn;
            this.commitCallbacks = new ArrayList<CommitCallback>();
            this.lastScn = firstScn;
        }

        public String toString() {
            return "Transaction{firstScn=" + this.firstScn + ", lastScn=" + this.lastScn + '}';
        }
    }

    public static interface CommitCallback {
        public void execute(BigInteger var1, BigInteger var2, int var3) throws InterruptedException;
    }
}

