/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle.logminer.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.schema.Column;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.oracle.logminer.parser.OracleColumnValue;
import org.dbsyncer.connector.oracle.logminer.parser.Parser;
import org.dbsyncer.sdk.model.Field;

public abstract class AbstractParser
implements Parser {
    protected Map<String, Expression> columnMap = new HashMap<String, Expression>();
    protected List<Field> fields;

    public void findColumn(Expression expression) {
        if (expression instanceof IsNullExpression) {
            IsNullExpression isNullExpression = (IsNullExpression)expression;
            Column column = (Column)isNullExpression.getLeftExpression();
            this.columnMap.put(StringUtil.replace((String)column.getColumnName(), (String)"\"", (String)""), expression);
            return;
        }
        BinaryExpression binaryExpression = (BinaryExpression)expression;
        if (binaryExpression.getLeftExpression() instanceof Column) {
            Column column = (Column)binaryExpression.getLeftExpression();
            this.columnMap.put(StringUtil.replace((String)column.getColumnName(), (String)"\"", (String)""), binaryExpression.getRightExpression());
            return;
        }
        this.findColumn(binaryExpression.getLeftExpression());
        this.findColumn(binaryExpression.getRightExpression());
    }

    public List<Object> columnMapToData() {
        LinkedList<Object> data = new LinkedList<Object>();
        block6: for (Field field : this.fields) {
            OracleColumnValue oracleColumnValue = new OracleColumnValue(this.columnMap.get(field.getName()));
            if (oracleColumnValue.isNull()) {
                data.add(null);
                continue;
            }
            switch (field.getType()) {
                case 2: {
                    data.add(this.convertNumber(oracleColumnValue, field));
                    continue block6;
                }
                case 3: {
                    data.add(oracleColumnValue.asBigDecimal());
                    continue block6;
                }
                case 92: 
                case 93: {
                    data.add(oracleColumnValue.asTimestamp());
                    continue block6;
                }
                case -101: {
                    data.add(oracleColumnValue.asOffsetDateTime());
                    continue block6;
                }
            }
            data.add(oracleColumnValue.asString());
        }
        return data;
    }

    private Object convertNumber(OracleColumnValue oracleColumnValue, Field field) {
        if (field.getRatio() <= 0) {
            int result = field.getColumnSize() - field.getRatio();
            if (result < 10) {
                return oracleColumnValue.asInteger();
            }
            if (result < 19) {
                return oracleColumnValue.asBigInteger();
            }
            if (result < 39) {
                return oracleColumnValue.asBigDecimal();
            }
            return oracleColumnValue.asString();
        }
        return oracleColumnValue.asBigDecimal();
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }
}

