/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.postgresql;

import org.dbsyncer.connector.postgresql.cdc.DqlPostgreSQLListener;
import org.dbsyncer.connector.postgresql.validator.DqlPostgreSQLConfigValidator;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.database.AbstractDQLConnector;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.listener.DatabaseQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.PageSql;

public final class DQLPostgreSQLConnector
extends AbstractDQLConnector {
    private final String TYPE = "DqlPostgreSQL";
    private final DqlPostgreSQLConfigValidator configValidator = new DqlPostgreSQLConfigValidator();

    public String getConnectorType() {
        return "DqlPostgreSQL";
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new DatabaseQuartzListener();
        }
        if (ListenerTypeEnum.isLog((String)listenerType)) {
            return new DqlPostgreSQLListener();
        }
        return null;
    }

    public String getPageSql(PageSql config) {
        return config.getQuerySql() + " limit ? OFFSET ?";
    }

    public Object[] getPageArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        int pageIndex = config.getPageIndex();
        return new Object[]{pageSize, (pageIndex - 1) * pageSize};
    }

    public String buildSqlWithQuotation() {
        return "\"";
    }
}

