/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.postgresql.cdc;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dbsyncer.common.QueueOverflowException;
import org.dbsyncer.common.util.BooleanUtil;
import org.dbsyncer.connector.postgresql.PostgreSQLException;
import org.dbsyncer.connector.postgresql.decoder.MessageDecoder;
import org.dbsyncer.connector.postgresql.enums.MessageDecoderEnum;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.connector.database.DatabaseTemplate;
import org.dbsyncer.sdk.listener.AbstractDatabaseListener;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.dbsyncer.sdk.model.ChangedOffset;
import org.dbsyncer.sdk.util.DatabaseUtil;
import org.postgresql.PGConnection;
import org.postgresql.PGProperty;
import org.postgresql.replication.LogSequenceNumber;
import org.postgresql.replication.PGReplicationStream;
import org.postgresql.replication.fluent.logical.ChainedLogicalCreateSlotBuilder;
import org.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PostgreSQLListener
extends AbstractDatabaseListener {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String GET_SLOT = "select count(1) from pg_replication_slots where database = ? and slot_name = ? and plugin = ?";
    private static final String GET_RESTART_LSN = "select restart_lsn from pg_replication_slots where database = ? and slot_name = ? and plugin = ?";
    private static final String GET_ROLE = "SELECT r.rolcanlogin AS login, r.rolreplication AS replication, CAST(array_position(ARRAY(SELECT b.rolname FROM pg_catalog.pg_auth_members m JOIN pg_catalog.pg_roles b ON (m.roleid = b.oid) WHERE m.member = r.oid), 'rds_superuser') AS BOOL) IS TRUE AS superuser, CAST(array_position(ARRAY(SELECT b.rolname FROM pg_catalog.pg_auth_members m JOIN pg_catalog.pg_roles b ON (m.roleid = b.oid) WHERE m.member = r.oid), 'rdsadmin') AS BOOL) IS TRUE AS admin, CAST(array_position(ARRAY(SELECT b.rolname FROM pg_catalog.pg_auth_members m JOIN pg_catalog.pg_roles b ON (m.roleid = b.oid) WHERE m.member = r.oid), 'rdsrepladmin') AS BOOL) IS TRUE AS rep_admin FROM pg_roles r WHERE r.rolname = current_user";
    private static final String GET_DATABASE = "SELECT current_database()";
    private static final String GET_WAL_LEVEL = "SHOW WAL_LEVEL";
    private static final String DEFAULT_WAL_LEVEL = "logical";
    private static final String PLUGIN_NAME = "pluginName";
    private static final String LSN_POSITION = "position";
    private static final String DROP_SLOT_ON_CLOSE = "dropSlotOnClose";
    private final Lock connectLock = new ReentrantLock();
    private volatile boolean connected;
    private DatabaseConfig config;
    private DatabaseConnectorInstance instance;
    private Connection connection;
    private PGReplicationStream stream;
    private boolean dropSlotOnClose;
    private MessageDecoder messageDecoder;
    private Worker worker;
    private LogSequenceNumber startLsn;
    private String database;

    public void start() {
        try {
            this.connectLock.lock();
            if (this.connected) {
                this.logger.error("PostgreSQLExtractor is already started");
                return;
            }
            this.instance = (DatabaseConnectorInstance)this.connectorInstance;
            this.config = this.instance.getConfig();
            String walLevel = (String)this.instance.execute(databaseTemplate -> (String)databaseTemplate.queryForObject(GET_WAL_LEVEL, String.class));
            if (!DEFAULT_WAL_LEVEL.equals(walLevel)) {
                throw new PostgreSQLException(String.format("Postgres server wal_level property must be \"%s\" but is: %s", DEFAULT_WAL_LEVEL, walLevel));
            }
            boolean hasAuth = (Boolean)this.instance.execute(databaseTemplate -> {
                Map rs = databaseTemplate.queryForMap(GET_ROLE);
                Boolean login = rs.getOrDefault("login", false);
                Boolean replication = rs.getOrDefault("replication", false);
                Boolean superuser = rs.getOrDefault("superuser", false);
                Boolean admin = rs.getOrDefault("admin", false);
                Boolean repAdmin = rs.getOrDefault("rep_admin", false);
                return login != false && (replication != false || superuser != false || admin != false || repAdmin != false);
            });
            if (!hasAuth) {
                throw new PostgreSQLException(String.format("Postgres roles LOGIN and REPLICATION are not assigned to user: %s", this.config.getUsername()));
            }
            this.database = (String)this.instance.execute(databaseTemplate -> (String)databaseTemplate.queryForObject(GET_DATABASE, String.class));
            this.messageDecoder = MessageDecoderEnum.getMessageDecoder(this.config.getProperty(PLUGIN_NAME));
            this.messageDecoder.setMetaId(this.metaId);
            this.messageDecoder.setConfig(this.config);
            this.messageDecoder.postProcessBeforeInitialization(this.connectorService, this.instance);
            this.dropSlotOnClose = BooleanUtil.toBoolean((String)this.config.getProperty(DROP_SLOT_ON_CLOSE, "true"));
            this.connect();
            this.connected = true;
            this.worker = new Worker();
            this.worker.setName("wal-parser-" + this.config.getUrl() + "_" + this.worker.hashCode());
            this.worker.setDaemon(false);
            this.worker.start();
        }
        catch (Exception e) {
            this.logger.error("\u542f\u52a8\u5931\u8d25:{}", (Object)e.getMessage());
            DatabaseUtil.close((AutoCloseable)this.stream);
            DatabaseUtil.close((AutoCloseable)this.connection);
            throw new PostgreSQLException(e);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    public void close() {
        try {
            this.connected = false;
            if (null != this.worker && !this.worker.isInterrupted()) {
                this.worker.interrupt();
                this.worker = null;
            }
            DatabaseUtil.close((AutoCloseable)this.stream);
            DatabaseUtil.close((AutoCloseable)this.connection);
            this.dropReplicationSlot();
        }
        catch (Exception e) {
            this.logger.error("\u5173\u95ed\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    public void refreshEvent(ChangedOffset offset) {
        this.snapshot.put(LSN_POSITION, String.valueOf(offset.getPosition()));
    }

    private void connect() throws SQLException {
        Properties props = new Properties();
        PGProperty.USER.set(props, this.config.getUsername());
        PGProperty.PASSWORD.set(props, this.config.getPassword());
        PGProperty.ASSUME_MIN_SERVER_VERSION.set(props, "9.4");
        PGProperty.REPLICATION.set(props, "database");
        PGProperty.PREFER_QUERY_MODE.set(props, "simple");
        this.connection = DriverManager.getConnection(this.config.getUrl(), props);
        Assert.notNull((Object)this.connection, (String)"Unable to get connection.");
        PGConnection pgConnection = this.connection.unwrap(PGConnection.class);
        this.createReplicationSlot(pgConnection);
        this.createReplicationStream(pgConnection);
        this.sleepInMills(10L);
    }

    private void createReplicationStream(PGConnection pgConnection) throws SQLException {
        ChainedLogicalStreamBuilder streamBuilder = (ChainedLogicalStreamBuilder)((ChainedLogicalStreamBuilder)((ChainedLogicalStreamBuilder)pgConnection.getReplicationAPI().replicationStream().logical().withSlotName(this.messageDecoder.getSlotName())).withStartPosition(this.startLsn)).withStatusInterval(10, TimeUnit.SECONDS);
        this.messageDecoder.withSlotOption(streamBuilder);
        this.stream = streamBuilder.start();
    }

    private void createReplicationSlot(PGConnection pgConnection) throws SQLException {
        String plugin;
        String slotName = this.messageDecoder.getSlotName();
        boolean existSlot = (Boolean)this.instance.execute(arg_0 -> this.lambda$createReplicationSlot$3(slotName, plugin = this.messageDecoder.getOutputPlugin(), arg_0));
        if (!existSlot) {
            ((ChainedLogicalCreateSlotBuilder)pgConnection.getReplicationAPI().createReplicationSlot().logical().withSlotName(slotName)).withOutputPlugin(plugin).make();
            this.sleepInMills(300L);
        }
        if (!this.snapshot.containsKey(LSN_POSITION)) {
            LogSequenceNumber lsn = (LogSequenceNumber)this.instance.execute(databaseTemplate -> LogSequenceNumber.valueOf((String)((String)databaseTemplate.queryForObject(GET_RESTART_LSN, new Object[]{this.database, slotName, plugin}, String.class))));
            if (null == lsn || lsn.asLong() == 0L) {
                throw new PostgreSQLException("No maximum LSN recorded in the database");
            }
            this.snapshot.put(LSN_POSITION, lsn.asString());
            super.forceFlushEvent();
        }
        this.startLsn = LogSequenceNumber.valueOf((String)((String)this.snapshot.get(LSN_POSITION)));
    }

    private void dropReplicationSlot() {
        if (!this.dropSlotOnClose) {
            return;
        }
        String slotName = this.messageDecoder.getSlotName();
        int ATTEMPTS = 3;
        for (int i = 0; i < 3; ++i) {
            try {
                this.instance.execute(databaseTemplate -> {
                    databaseTemplate.execute(String.format("select pg_drop_replication_slot('%s')", slotName));
                    return true;
                });
                break;
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof PSQLException)) continue;
                PSQLException ex = (PSQLException)e.getCause();
                if (PSQLState.OBJECT_IN_USE.getState().equals(ex.getSQLState())) {
                    if (i < 2) {
                        this.logger.debug("Cannot drop replication slot '{}' because it's still in use", (Object)slotName);
                        continue;
                    }
                    this.logger.warn("Cannot drop replication slot '{}' because it's still in use", (Object)slotName);
                    break;
                }
                if (PSQLState.UNDEFINED_OBJECT.getState().equals(ex.getSQLState())) {
                    this.logger.debug("Replication slot {} has already been dropped", (Object)slotName);
                    break;
                }
                this.logger.error("Unexpected error while attempting to drop replication slot", (Throwable)ex);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() {
        this.connectLock.lock();
        try {
            long s = Instant.now().toEpochMilli();
            DatabaseUtil.close((AutoCloseable)this.stream);
            DatabaseUtil.close((AutoCloseable)this.connection);
            this.stream = null;
            this.connection = null;
            while (this.connected) {
                try {
                    this.connect();
                    break;
                }
                catch (Exception e) {
                    this.logger.error("Recover streaming occurred error");
                    DatabaseUtil.close((AutoCloseable)this.stream);
                    DatabaseUtil.close((AutoCloseable)this.connection);
                    this.sleepInMills(3000L);
                }
            }
            long e = Instant.now().toEpochMilli();
            this.logger.info("Recover logical replication success, slot:{}, plugin:{}, cost:{}seconds", new Object[]{this.messageDecoder.getSlotName(), this.messageDecoder.getOutputPlugin(), (e - s) / 1000L});
        }
        finally {
            this.connectLock.unlock();
        }
    }

    private /* synthetic */ Object lambda$createReplicationSlot$3(String slotName, String plugin, DatabaseTemplate databaseTemplate) throws Exception {
        return (Integer)databaseTemplate.queryForObject(GET_SLOT, new Object[]{this.database, slotName, plugin}, Integer.class) > 0;
    }

    final class Worker
    extends Thread {
        Worker() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && PostgreSQLListener.this.connected) {
                try {
                    ByteBuffer msg = PostgreSQLListener.this.stream.readPending();
                    if (msg == null) {
                        PostgreSQLListener.this.sleepInMills(10L);
                        continue;
                    }
                    LogSequenceNumber lsn = PostgreSQLListener.this.stream.getLastReceiveLSN();
                    if (PostgreSQLListener.this.messageDecoder.skipMessage(msg, PostgreSQLListener.this.startLsn, lsn)) continue;
                    RowChangedEvent event = PostgreSQLListener.this.messageDecoder.processMessage(msg);
                    if (event != null) {
                        event.setPosition((Object)lsn.asString());
                        while (PostgreSQLListener.this.connected) {
                            try {
                                PostgreSQLListener.this.sendChangedEvent((ChangedEvent)event);
                                break;
                            }
                            catch (QueueOverflowException ex) {
                                try {
                                    TimeUnit.MILLISECONDS.sleep(1L);
                                }
                                catch (InterruptedException exe) {
                                    PostgreSQLListener.this.logger.error(exe.getMessage(), (Throwable)exe);
                                }
                            }
                        }
                    }
                    PostgreSQLListener.this.stream.setAppliedLSN(lsn);
                    PostgreSQLListener.this.stream.setFlushedLSN(lsn);
                    PostgreSQLListener.this.stream.forceUpdateStatus();
                }
                catch (IllegalStateException | PostgreSQLException e) {
                    PostgreSQLListener.this.logger.error(e.getMessage());
                }
                catch (Exception e) {
                    PostgreSQLListener.this.logger.error(e.getMessage(), (Throwable)e);
                    PostgreSQLListener.this.recover();
                }
            }
        }
    }
}

