/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.postgresql.column;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.dbsyncer.common.column.AbstractColumnValue;
import org.dbsyncer.common.util.DateFormatUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.postgresql.PostgreSQLException;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PgColumnValue
extends AbstractColumnValue<String> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public PgColumnValue(String value) {
        this.setValue(value);
    }

    public String asString() {
        return (String)this.getValue();
    }

    public byte[] asByteArray() {
        return StringUtil.hexStringToByteArray((String)((String)this.getValue()).substring(2));
    }

    public Short asShort() {
        return Short.valueOf((String)this.getValue());
    }

    public Integer asInteger() {
        return Integer.valueOf((String)this.getValue());
    }

    public Long asLong() {
        return Long.valueOf((String)this.getValue());
    }

    public Float asFloat() {
        return Float.valueOf((String)this.getValue());
    }

    public Double asDouble() {
        return Double.valueOf((String)this.getValue());
    }

    public Boolean asBoolean() {
        return "t".equalsIgnoreCase((String)this.getValue());
    }

    public BigDecimal asBigDecimal() {
        return new BigDecimal((String)this.getValue());
    }

    public Date asDate() {
        return DateFormatUtil.stringToDate((String)this.asString());
    }

    public Timestamp asTimestamp() {
        if ("infinity".equals(this.asString())) {
            return Timestamp.from(this.toInstantFromMicros(9223372036825200000L));
        }
        if ("-infinity".equals(this.asString())) {
            return Timestamp.from(this.toInstantFromMicros(-9223372036832400000L));
        }
        if ("null".equals(this.asString()) || StringUtil.isBlank((CharSequence)this.asString())) {
            return null;
        }
        return DateFormatUtil.timeWithoutTimeZoneToTimestamp((String)this.asString());
    }

    public Time asTime() {
        return Time.valueOf((String)this.getValue());
    }

    public LocalTime asLocalTime() {
        return DateFormatUtil.stringToLocalTime((String)this.asString());
    }

    public OffsetTime asOffsetTimeUtc() {
        return DateFormatUtil.timeWithTimeZone((String)this.asString());
    }

    public OffsetDateTime asOffsetDateTimeAtUtc() {
        if ("infinity".equals(this.asString())) {
            return OffsetDateTime.ofInstant(this.toInstantFromMillis(9223372036825200000L), ZoneOffset.UTC);
        }
        if ("-infinity".equals(this.asString())) {
            return OffsetDateTime.ofInstant(this.toInstantFromMillis(-9223372036832400000L), ZoneOffset.UTC);
        }
        return DateFormatUtil.timestampWithTimeZoneToOffsetDateTime((String)this.asString());
    }

    public PGbox asBox() {
        try {
            return new PGbox(this.asString());
        }
        catch (SQLException e) {
            this.logger.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new PostgreSQLException(e);
        }
    }

    public PGcircle asCircle() {
        try {
            return new PGcircle(this.asString());
        }
        catch (SQLException e) {
            this.logger.error("Failed to parse circle {}, {}", (Object)this.asString(), (Object)e);
            throw new PostgreSQLException(e);
        }
    }

    public Object asInterval() {
        try {
            return new PGInterval(this.asString());
        }
        catch (SQLException e) {
            this.logger.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new PostgreSQLException(e);
        }
    }

    public PGline asLine() {
        try {
            return new PGline(this.asString());
        }
        catch (SQLException e) {
            this.logger.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new PostgreSQLException(e);
        }
    }

    public PGlseg asLseg() {
        try {
            return new PGlseg(this.asString());
        }
        catch (SQLException e) {
            this.logger.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new PostgreSQLException(e);
        }
    }

    public PGmoney asMoney() {
        try {
            String value = this.asString();
            if (value != null && value.startsWith("-")) {
                String negativeMoney = "(" + value.substring(1) + ")";
                return new PGmoney(negativeMoney);
            }
            return new PGmoney(this.asString());
        }
        catch (SQLException e) {
            this.logger.error("Failed to parse money {}, {}", (Object)this.asString(), (Object)e);
            throw new PostgreSQLException(e);
        }
    }

    public PGpath asPath() {
        try {
            return new PGpath(this.asString());
        }
        catch (SQLException e) {
            this.logger.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new PostgreSQLException(e);
        }
    }

    public PGpoint asPoint() {
        try {
            return new PGpoint(this.asString());
        }
        catch (SQLException e) {
            this.logger.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new PostgreSQLException(e);
        }
    }

    public PGpolygon asPolygon() {
        try {
            return new PGpolygon(this.asString());
        }
        catch (SQLException e) {
            this.logger.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new PostgreSQLException(e);
        }
    }

    private Instant toInstantFromMicros(long microsSinceEpoch) {
        return Instant.ofEpochSecond(TimeUnit.MICROSECONDS.toSeconds(microsSinceEpoch), TimeUnit.MICROSECONDS.toNanos(microsSinceEpoch % TimeUnit.SECONDS.toMicros(1L)));
    }

    private Instant toInstantFromMillis(long millisecondSinceEpoch) {
        return Instant.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(millisecondSinceEpoch), TimeUnit.MILLISECONDS.toNanos(millisecondSinceEpoch % TimeUnit.SECONDS.toMillis(1L)));
    }
}

