/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.postgresql;

import java.util.List;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.postgresql.cdc.PostgreSQLListener;
import org.dbsyncer.connector.postgresql.schema.PostgreSQLBitValueMapper;
import org.dbsyncer.connector.postgresql.schema.PostgreSQLOtherValueMapper;
import org.dbsyncer.connector.postgresql.validator.PostgreSQLConfigValidator;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.database.AbstractDatabaseConnector;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.enums.TableTypeEnum;
import org.dbsyncer.sdk.listener.DatabaseQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.PageSql;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgreSQLConnector
extends AbstractDatabaseConnector {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String TYPE = "PostgreSQL";
    private final PostgreSQLConfigValidator configValidator = new PostgreSQLConfigValidator();

    public PostgreSQLConnector() {
        this.VALUE_MAPPERS.put(-7, new PostgreSQLBitValueMapper());
        this.VALUE_MAPPERS.put(1111, new PostgreSQLOtherValueMapper());
    }

    public String getConnectorType() {
        return "PostgreSQL";
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new DatabaseQuartzListener();
        }
        if (ListenerTypeEnum.isLog((String)listenerType)) {
            return new PostgreSQLListener();
        }
        return null;
    }

    public String buildSqlWithQuotation() {
        return "\"";
    }

    public String getPageSql(PageSql config) {
        StringBuilder sql = new StringBuilder(config.getQuerySql());
        if (PrimaryKeyUtil.isSupportedCursor((List)config.getFields())) {
            this.appendOrderByPk(config, sql);
        }
        sql.append(" limit ? OFFSET ?");
        return sql.toString();
    }

    public String getPageCursorSql(PageSql config) {
        if (!PrimaryKeyUtil.isSupportedCursor((List)config.getFields())) {
            this.logger.debug("\u4e0d\u652f\u6301\u6e38\u6807\u67e5\u8be2\uff0c\u4e3b\u952e\u5305\u542b\u975e\u6570\u5b57\u7c7b\u578b");
            return "";
        }
        StringBuilder sql = new StringBuilder(config.getQuerySql());
        boolean skipFirst = false;
        if (StringUtil.isBlank((CharSequence)config.getQueryFilter())) {
            skipFirst = true;
            sql.append(" WHERE ");
        }
        List primaryKeys = config.getPrimaryKeys();
        String quotation = this.buildSqlWithQuotation();
        PrimaryKeyUtil.buildSql((StringBuilder)sql, (List)primaryKeys, (String)quotation, (String)" AND ", (String)" > ? ", (boolean)skipFirst);
        this.appendOrderByPk(config, sql);
        sql.append(" limit ? OFFSET ?");
        return sql.toString();
    }

    public Object[] getPageArgs(ReaderConfig config) {
        int pageIndex = config.getPageIndex();
        int pageSize = config.getPageSize();
        return new Object[]{pageSize, (pageIndex - 1) * pageSize};
    }

    public Object[] getPageCursorArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        Object[] cursors = config.getCursors();
        if (null == cursors) {
            return new Object[]{pageSize, 0};
        }
        int cursorsLen = cursors.length;
        Object[] newCursors = new Object[cursorsLen + 2];
        System.arraycopy(cursors, 0, newCursors, 0, cursorsLen);
        newCursors[cursorsLen] = pageSize;
        newCursors[cursorsLen + 1] = 0;
        return newCursors;
    }

    protected String getQueryCountSql(CommandConfig commandConfig, List<String> primaryKeys, String schema, String queryFilterSql) {
        Table table = commandConfig.getTable();
        if (StringUtil.isNotBlank((CharSequence)queryFilterSql) || TableTypeEnum.isView((String)table.getType())) {
            return super.getQueryCountSql(commandConfig, primaryKeys, schema, queryFilterSql);
        }
        DatabaseConfig cfg = (DatabaseConfig)commandConfig.getConnectorConfig();
        return String.format("SELECT N_LIVE_TUP FROM PG_STAT_USER_TABLES WHERE SCHEMANAME='%s' AND RELNAME='%s'", cfg.getSchema(), table.getName());
    }

    public boolean enableCursor() {
        return true;
    }
}

