/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.postgresql.decoder.impl;

import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.connector.postgresql.PostgreSQLException;
import org.dbsyncer.connector.postgresql.decoder.AbstractMessageDecoder;
import org.dbsyncer.connector.postgresql.enums.MessageDecoderEnum;
import org.dbsyncer.connector.postgresql.enums.MessageTypeEnum;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.spi.ConnectorService;
import org.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PgOutputMessageDecoder
extends AbstractMessageDecoder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final LocalDateTime PG_EPOCH = LocalDateTime.of(2000, 1, 1, 0, 0, 0);
    private static final String GET_TABLE_SCHEMA = "select t.oid,t.relname as tableName from pg_class t inner join (select ns.oid as nspoid, ns.nspname from pg_namespace ns where ns.nspname = '%s') as n on n.nspoid = t.relnamespace where relkind = 'r'";
    private static final Map<Integer, TableId> tables = new LinkedHashMap<Integer, TableId>();
    private ConnectorService connectorService;
    private DatabaseConnectorInstance connectorInstance;

    @Override
    public void postProcessBeforeInitialization(ConnectorService connectorService, DatabaseConnectorInstance connectorInstance) {
        this.connectorService = connectorService;
        this.connectorInstance = connectorInstance;
        this.initPublication();
        this.readSchema();
    }

    @Override
    public RowChangedEvent processMessage(ByteBuffer buffer) {
        if (!buffer.hasArray()) {
            throw new IllegalStateException("Invalid buffer received from PG server during streaming replication");
        }
        MessageTypeEnum type = MessageTypeEnum.getType((char)buffer.get());
        switch (type) {
            case UPDATE: 
            case INSERT: 
            case DELETE: {
                return this.parseData(type, buffer);
            }
            case BEGIN: {
                long beginLsn = buffer.getLong();
                long beginTs = buffer.getLong();
                long xid = buffer.getInt();
                this.logger.info("Begin LSN {}, timestamp {}, xid {} - {}", new Object[]{beginLsn, PG_EPOCH.plusNanos(beginTs * 1000L), xid, beginTs});
                break;
            }
            case COMMIT: {
                buffer.get();
                long commitLsn = buffer.getLong();
                long commitEndLsn = buffer.getLong();
                long commitTs = buffer.getLong();
                this.logger.info("Commit: LSN {}, end LSN {}, ts {}", new Object[]{commitLsn, commitEndLsn, PG_EPOCH.plusNanos(commitTs * 1000L)});
                break;
            }
            default: {
                this.logger.info("Type {} not implemented", (Object)type.name());
            }
        }
        return null;
    }

    @Override
    public String getOutputPlugin() {
        return MessageDecoderEnum.PG_OUTPUT.getType();
    }

    @Override
    public void withSlotOption(ChainedLogicalStreamBuilder builder) {
        builder.withSlotOption("proto_version", 1);
        builder.withSlotOption("publication_names", this.getPubName());
    }

    private String getPubName() {
        return String.format("dbs_pub_%s_%s", this.config.getSchema(), this.config.getUsername()).toLowerCase();
    }

    private void initPublication() {
        String pubName = this.getPubName();
        String selectPublication = String.format("SELECT COUNT(1) FROM pg_publication WHERE pubname = '%s'", pubName);
        Integer count = (Integer)this.connectorInstance.execute(databaseTemplate -> (Integer)databaseTemplate.queryForObject(selectPublication, Integer.class));
        if (0 < count) {
            return;
        }
        this.logger.info("Creating new publication '{}' for plugin '{}'", (Object)pubName, (Object)this.getOutputPlugin());
        try {
            String createPublication = String.format("CREATE PUBLICATION %s FOR ALL TABLES", pubName);
            this.logger.info("Creating Publication with statement '{}'", (Object)createPublication);
            this.connectorInstance.execute(databaseTemplate -> {
                databaseTemplate.execute(createPublication);
                return true;
            });
        }
        catch (Exception e) {
            throw new PostgreSQLException(e.getCause());
        }
    }

    private void readSchema() {
        String querySchema = String.format(GET_TABLE_SCHEMA, this.config.getSchema());
        List schemas = (List)this.connectorInstance.execute(databaseTemplate -> databaseTemplate.queryForList(querySchema));
        if (!CollectionUtils.isEmpty((Collection)schemas)) {
            schemas.forEach(map -> {
                Long oid = (Long)map.get("oid");
                String tableName = (String)map.get("tableName");
                MetaInfo metaInfo = this.connectorService.getMetaInfo((ConnectorInstance)this.connectorInstance, tableName);
                Assert.notEmpty((Collection)metaInfo.getColumn(), (String)String.format("The table column for '%s' must not be empty.", tableName));
                tables.put(oid.intValue(), new TableId(oid.intValue(), tableName, metaInfo.getColumn()));
            });
        }
    }

    private RowChangedEvent parseData(MessageTypeEnum type, ByteBuffer buffer) {
        int relationId = buffer.getInt();
        TableId tableId = tables.get(relationId);
        if (null != tableId) {
            String newTuple;
            switch (newTuple = new String(new byte[]{buffer.get()}, 0, 1)) {
                case "N": 
                case "K": 
                case "O": {
                    ArrayList<Object> data = new ArrayList<Object>();
                    this.readTupleData(tableId, buffer, data);
                    return new RowChangedEvent(tableId.tableName, type.name(), data);
                }
            }
            this.logger.info("N, K, O not set, got instead {}", (Object)newTuple);
        }
        return null;
    }

    private void readTupleData(TableId tableId, ByteBuffer msg, List<Object> data) {
        int nColumn = msg.getShort();
        if (nColumn != tableId.fields.size()) {
            this.logger.warn("The column size of table '{}' is {}, but we has been received column size is {}.", new Object[]{tableId.tableName, tableId.fields.size(), (short)nColumn});
            MetaInfo metaInfo = this.connectorService.getMetaInfo((ConnectorInstance)this.connectorInstance, tableId.tableName);
            if (CollectionUtils.isEmpty((Collection)metaInfo.getColumn())) {
                throw new PostgreSQLException(String.format("The table column for '%s' is empty.", tableId.tableName));
            }
            tableId.fields = metaInfo.getColumn();
            return;
        }
        block10: for (int n = 0; n < nColumn; ++n) {
            String type;
            switch (type = new String(new byte[]{msg.get()}, 0, 1)) {
                case "t": {
                    int size = msg.getInt();
                    byte[] text = new byte[size];
                    for (int z = 0; z < size; ++z) {
                        text[z] = msg.get();
                    }
                    data.add(this.resolveValue(tableId.fields.get(n).getTypeName(), new String(text, 0, size)));
                    continue block10;
                }
                case "n": {
                    data.add(null);
                    continue block10;
                }
                case "u": {
                    data.add("TOASTED");
                    continue block10;
                }
                default: {
                    this.logger.info("t, n, u not set, got instead {}", (Object)type);
                }
            }
        }
    }

    final class TableId {
        Integer oid;
        String tableName;
        List<Field> fields;

        public TableId(Integer oid, String tableName, List<Field> fields) {
            this.oid = oid;
            this.tableName = tableName;
            this.fields = fields;
        }
    }
}

