/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.postgresql.enums;

import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.postgresql.PostgreSQLException;
import org.dbsyncer.connector.postgresql.decoder.MessageDecoder;
import org.dbsyncer.connector.postgresql.decoder.impl.PgOutputMessageDecoder;
import org.dbsyncer.connector.postgresql.decoder.impl.TestDecodingMessageDecoder;

public enum MessageDecoderEnum {
    TEST_DECODING("test_decoding", TestDecodingMessageDecoder.class),
    PG_OUTPUT("pgoutput", PgOutputMessageDecoder.class);

    private String type;
    private Class<?> clazz;

    private MessageDecoderEnum(String type, Class<?> clazz) {
        this.type = type;
        this.clazz = clazz;
    }

    public static MessageDecoder getMessageDecoder(String type) throws PostgreSQLException, IllegalAccessException, InstantiationException {
        for (MessageDecoderEnum e : MessageDecoderEnum.values()) {
            if (!StringUtil.equals((CharSequence)type, (CharSequence)e.getType())) continue;
            return (MessageDecoder)e.getClazz().newInstance();
        }
        return (MessageDecoder)TEST_DECODING.getClazz().newInstance();
    }

    public String getType() {
        return this.type;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }
}

