/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.storage.binlog;

import com.google.protobuf.ByteString;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.dbsyncer.common.column.AbstractColumnValue;
import org.dbsyncer.storage.enums.BinlogByteEnum;

public class BinlogColumnValue
extends AbstractColumnValue<ByteString> {
    public BinlogColumnValue(ByteString v) {
        this.setValue(v);
    }

    public String asString() {
        return ((ByteString)this.getValue()).toStringUtf8();
    }

    public byte[] asByteArray() {
        return ((ByteString)this.getValue()).toByteArray();
    }

    public Short asShort() {
        ByteBuffer buffer = ByteBuffer.allocate(BinlogByteEnum.SHORT.getByteLength());
        buffer.put(this.asByteArray(), 0, buffer.capacity());
        buffer.flip();
        return buffer.asShortBuffer().get();
    }

    public Integer asInteger() {
        byte[] bytes = this.asByteArray();
        if (bytes.length == BinlogByteEnum.SHORT.getByteLength()) {
            Short aShort = this.asShort();
            return new Integer(aShort.shortValue());
        }
        ByteBuffer buffer = ByteBuffer.allocate(BinlogByteEnum.INTEGER.getByteLength());
        buffer.put(bytes, 0, buffer.capacity());
        buffer.flip();
        return buffer.asIntBuffer().get();
    }

    public Long asLong() {
        ByteBuffer buffer = ByteBuffer.allocate(BinlogByteEnum.LONG.getByteLength());
        buffer.put(this.asByteArray(), 0, buffer.capacity());
        buffer.flip();
        return buffer.asLongBuffer().get();
    }

    public Float asFloat() {
        ByteBuffer buffer = ByteBuffer.allocate(BinlogByteEnum.FLOAT.getByteLength());
        buffer.put(this.asByteArray(), 0, buffer.capacity());
        buffer.flip();
        return Float.valueOf(buffer.asFloatBuffer().get());
    }

    public Double asDouble() {
        ByteBuffer buffer = ByteBuffer.allocate(BinlogByteEnum.DOUBLE.getByteLength());
        buffer.put(this.asByteArray(), 0, buffer.capacity());
        buffer.flip();
        return buffer.asDoubleBuffer().get();
    }

    public Boolean asBoolean() {
        ByteBuffer buffer = ByteBuffer.allocate(BinlogByteEnum.SHORT.getByteLength());
        buffer.put(this.asByteArray(), 0, buffer.capacity());
        buffer.flip();
        return buffer.asShortBuffer().get() == 1;
    }

    public BigDecimal asBigDecimal() {
        return new BigDecimal(this.asString());
    }

    public Date asDate() {
        return new Date(this.asLong());
    }

    public Timestamp asTimestamp() {
        return new Timestamp(this.asLong());
    }

    public Time asTime() {
        return new Time(this.asLong());
    }
}

