/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.storage.impl;

import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.sdk.filter.AbstractFilter;
import org.dbsyncer.storage.StorageException;

public class DiskQueryHelper {
    public static Query newEqual(AbstractFilter filter) {
        TermQuery query = null;
        switch (filter.getFilterTypeEnum()) {
            case STRING: {
                query = new TermQuery(new Term(filter.getName(), filter.getValue()));
                break;
            }
            case LONG: {
                query = LongPoint.newSetQuery((String)filter.getName(), (long[])new long[]{NumberUtil.toLong((String)filter.getValue())});
                break;
            }
            case INT: {
                query = IntPoint.newSetQuery((String)filter.getName(), (int[])new int[]{NumberUtil.toInt((String)filter.getValue())});
            }
        }
        if (query == null) {
            throw new StorageException("Unsupported method newEqual.");
        }
        return query;
    }

    public static Query newLessThan(AbstractFilter filter) {
        Query query = null;
        switch (filter.getFilterTypeEnum()) {
            case LONG: {
                query = LongPoint.newRangeQuery((String)filter.getName(), (long)Long.MIN_VALUE, (long)NumberUtil.toLong((String)filter.getValue()));
                break;
            }
            case INT: {
                query = IntPoint.newRangeQuery((String)filter.getName(), (int)Integer.MIN_VALUE, (int)NumberUtil.toInt((String)filter.getValue()));
            }
        }
        if (query == null) {
            throw new StorageException("Unsupported method newLessThan.");
        }
        return query;
    }
}

