CREATE TABLE `dbsyncer_data` (
  `ID` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '唯一ID',
  `SUCCESS` int(1) NOT NULL COMMENT '成功1/失败0',
  `TABLE_GROUP_ID` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '驱动表映射关系ID',
  `TARGET_TABLE_NAME` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '目标表名称',
  `EVENT` varchar(10) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '事件',
  `ERROR` mediumtext CHARACTER SET utf8 COLLATE utf8_bin NULL COMMENT '异常信息',
  `CREATE_TIME` bigint(0) NOT NULL COMMENT '创建时间',
  `DATA` blob NOT NULL COMMENT '同步数据',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IDX_SUCCESS`(`SUCCESS`) USING BTREE,
  INDEX `IDX_EVENT`(`EVENT`) USING BTREE,
  INDEX `IDX_SUCCESS_CREATE_TIME`(`SUCCESS`, `CREATE_TIME`) USING BTREE,
  FULLTEXT INDEX `FULL_TEXT_ERROR`(`ERROR`)
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin COMMENT = '同步数据表' ROW_FORMAT = Dynamic;