/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

class BCHelper {
    private static final Object[][] _codes = new Object[][]{{Byte.TYPE, "B"}, {Character.TYPE, "C"}, {Double.TYPE, "D"}, {Float.TYPE, "F"}, {Integer.TYPE, "I"}, {Long.TYPE, "J"}, {Short.TYPE, "S"}, {Boolean.TYPE, "Z"}, {Void.TYPE, "V"}};
    private static final Map _wrappers = new HashMap();
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$Character;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Short;

    public static Class getWrapperClass(String string) {
        if (string == null) {
            return null;
        }
        return (Class)_wrappers.get(string);
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        if (string == null) {
            throw new ClassNotFoundException("null");
        }
        int n = 0;
        while (n < _codes.length) {
            if (string.equals(_codes[n][1].toString())) {
                return (Class)_codes[n][0];
            }
            ++n;
        }
        return Class.forName(BCHelper.getExternalForm(string, false));
    }

    public static String getInternalForm(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = "";
        while (true) {
            if (string.endsWith("[]")) {
                string2 = string2 + "[";
                string = string.substring(0, string.length() - 2);
                continue;
            }
            if (!string.startsWith("[")) break;
            string2 = string2 + "[";
            string = string.substring(1);
        }
        int n = 0;
        while (n < _codes.length) {
            if (string.equals(_codes[n][1].toString()) || string.equals(_codes[n][0].toString())) {
                return string2 + _codes[n][1];
            }
            ++n;
        }
        if (string.startsWith("L") && string.endsWith(";")) {
            string = string.substring(1, string.length() - 1);
        }
        string = string.replace('.', '/');
        if (bl || string2.length() > 0) {
            return string2 + "L" + string + ";";
        }
        return string2 + string;
    }

    public static String getExternalForm(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (!bl) {
            string = BCHelper.getInternalForm(string, false);
            return string.replace('/', '.');
        }
        String string2 = "";
        while (string.startsWith("[")) {
            string = string.substring(1);
            string2 = string2 + "[]";
        }
        if (string.endsWith(";")) {
            string = string.substring(1, string.length() - 1);
        }
        int n = 0;
        while (n < _codes.length) {
            if (string.equals(_codes[n][1].toString())) {
                return _codes[n][0].toString() + string2;
            }
            ++n;
        }
        return string.replace('/', '.') + string2;
    }

    public static boolean hasFlag(int n, int n2) {
        return (n & n2) > 0;
    }

    public static int setFlag(int n, int n2, boolean bl) {
        n = bl ? (n |= n2) : (n &= ~n2);
        return n;
    }

    public static String getReturnType(String string) {
        return string.substring(string.indexOf(41) + 1);
    }

    public static String[] getParamTypes(String string) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        string = string.substring(1, string.indexOf(41));
        LinkedList<String> linkedList = new LinkedList<String>();
        while (string.length() > 0) {
            int n = 0;
            while (!Character.isLetter(string.charAt(n))) {
                ++n;
            }
            if (string.charAt(n) == 'L') {
                n = string.indexOf(59);
            }
            linkedList.add(string.substring(0, n + 1));
            string = string.substring(n + 1);
        }
        return linkedList.toArray(new String[0]);
    }

    public static String getDescriptor(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        stringBuffer.append(")");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    BCHelper() {
    }

    static {
        _wrappers.put(Byte.TYPE.getName(), class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = BCHelper.class$("java.lang.Byte")));
        _wrappers.put(Boolean.TYPE.getName(), class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = BCHelper.class$("java.lang.Boolean")));
        _wrappers.put(Character.TYPE.getName(), class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = BCHelper.class$("java.lang.Character")));
        _wrappers.put(Double.TYPE.getName(), class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = BCHelper.class$("java.lang.Double")));
        _wrappers.put(Float.TYPE.getName(), class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = BCHelper.class$("java.lang.Float")));
        _wrappers.put(Integer.TYPE.getName(), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = BCHelper.class$("java.lang.Integer")));
        _wrappers.put(Long.TYPE.getName(), class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = BCHelper.class$("java.lang.Long")));
        _wrappers.put(Short.TYPE.getName(), class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = BCHelper.class$("java.lang.Short")));
    }
}

