/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SOSMarkerSegment
extends MarkerSegment {
    int startSpectralSelection;
    int endSpectralSelection;
    int approxHigh;
    int approxLow;
    ScanComponentSpec[] componentSpecs;

    SOSMarkerSegment(boolean bl, byte[] byArray, int n) {
        super(218);
        this.startSpectralSelection = 0;
        this.endSpectralSelection = 63;
        this.approxHigh = 0;
        this.approxLow = 0;
        this.componentSpecs = new ScanComponentSpec[n];
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            if (bl && (i == 1 || i == 2)) {
                n2 = 1;
            }
            this.componentSpecs[i] = new ScanComponentSpec(byArray[i], n2);
        }
    }

    SOSMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        int n = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.componentSpecs = new ScanComponentSpec[n];
        for (int i = 0; i < n; ++i) {
            this.componentSpecs[i] = new ScanComponentSpec(jPEGBuffer);
        }
        this.startSpectralSelection = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.endSpectralSelection = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.approxHigh = jPEGBuffer.buf[jPEGBuffer.bufPtr] >> 4;
        this.approxLow = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
        jPEGBuffer.bufAvail -= this.length;
    }

    SOSMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(218);
        this.startSpectralSelection = 0;
        this.endSpectralSelection = 63;
        this.approxHigh = 0;
        this.approxLow = 0;
        this.updateFromNativeNode(node, true);
    }

    protected Object clone() {
        SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)super.clone();
        if (this.componentSpecs != null) {
            sOSMarkerSegment.componentSpecs = (ScanComponentSpec[])this.componentSpecs.clone();
            for (int i = 0; i < this.componentSpecs.length; ++i) {
                sOSMarkerSegment.componentSpecs[i] = (ScanComponentSpec)this.componentSpecs[i].clone();
            }
        }
        return sOSMarkerSegment;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("sos");
        iIOMetadataNode.setAttribute("numScanComponents", Integer.toString(this.componentSpecs.length));
        iIOMetadataNode.setAttribute("startSpectralSelection", Integer.toString(this.startSpectralSelection));
        iIOMetadataNode.setAttribute("endSpectralSelection", Integer.toString(this.endSpectralSelection));
        iIOMetadataNode.setAttribute("approxHigh", Integer.toString(this.approxHigh));
        iIOMetadataNode.setAttribute("approxLow", Integer.toString(this.approxLow));
        for (int i = 0; i < this.componentSpecs.length; ++i) {
            iIOMetadataNode.appendChild(this.componentSpecs[i].getNativeNode());
        }
        return iIOMetadataNode;
    }

    void updateFromNativeNode(Node node, boolean bl) throws IIOInvalidTreeException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "numScanComponents", 1, 4, true);
        int n2 = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "startSpectralSelection", 0, 63, false);
        this.startSpectralSelection = n2 != -1 ? n2 : this.startSpectralSelection;
        n2 = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "endSpectralSelection", 0, 63, false);
        this.endSpectralSelection = n2 != -1 ? n2 : this.endSpectralSelection;
        n2 = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "approxHigh", 0, 15, false);
        this.approxHigh = n2 != -1 ? n2 : this.approxHigh;
        n2 = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "approxLow", 0, 15, false);
        this.approxLow = n2 != -1 ? n2 : this.approxLow;
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() != n) {
            throw new IIOInvalidTreeException("numScanComponents must match the number of children", node);
        }
        this.componentSpecs = new ScanComponentSpec[n];
        for (int i = 0; i < n; ++i) {
            this.componentSpecs[i] = new ScanComponentSpec(nodeList.item(i));
        }
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }

    void print() {
        this.printTag("SOS");
        System.out.print("Start spectral selection: ");
        System.out.println(this.startSpectralSelection);
        System.out.print("End spectral selection: ");
        System.out.println(this.endSpectralSelection);
        System.out.print("Approx high: ");
        System.out.println(this.approxHigh);
        System.out.print("Approx low: ");
        System.out.println(this.approxLow);
        System.out.print("Num scan components: ");
        System.out.println(this.componentSpecs.length);
        for (int i = 0; i < this.componentSpecs.length; ++i) {
            this.componentSpecs[i].print();
        }
    }

    ScanComponentSpec getScanComponentSpec(byte by, int n) {
        return new ScanComponentSpec(by, n);
    }

    class ScanComponentSpec
    implements Cloneable {
        int componentSelector;
        int dcHuffTable;
        int acHuffTable;

        ScanComponentSpec(byte by, int n) {
            this.componentSelector = by;
            this.dcHuffTable = n;
            this.acHuffTable = n;
        }

        ScanComponentSpec(JPEGBuffer jPEGBuffer) {
            this.componentSelector = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
            this.dcHuffTable = jPEGBuffer.buf[jPEGBuffer.bufPtr] >> 4;
            this.acHuffTable = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
        }

        ScanComponentSpec(Node node) throws IIOInvalidTreeException {
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.componentSelector = MarkerSegment.getAttributeValue(node, namedNodeMap, "componentSelector", 0, 255, true);
            this.dcHuffTable = MarkerSegment.getAttributeValue(node, namedNodeMap, "dcHuffTable", 0, 3, true);
            this.acHuffTable = MarkerSegment.getAttributeValue(node, namedNodeMap, "acHuffTable", 0, 3, true);
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("scanComponentSpec");
            iIOMetadataNode.setAttribute("componentSelector", Integer.toString(this.componentSelector));
            iIOMetadataNode.setAttribute("dcHuffTable", Integer.toString(this.dcHuffTable));
            iIOMetadataNode.setAttribute("acHuffTable", Integer.toString(this.acHuffTable));
            return iIOMetadataNode;
        }

        void print() {
            System.out.print("Component Selector: ");
            System.out.println(this.componentSelector);
            System.out.print("DC huffman table: ");
            System.out.println(this.dcHuffTable);
            System.out.print("AC huffman table: ");
            System.out.println(this.acHuffTable);
        }
    }
}

