/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.EntryPair;
import java.text.RBCollationTables;
import java.text.RuleBasedCollator;
import java.util.Vector;
import sun.text.CollatorUtilities;
import sun.text.normalizer.NormalizerBase;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    static final int UNMAPPEDCHARVALUE = 0x7FFF0000;
    private NormalizerBase text = null;
    private int[] buffer = null;
    private int expIndex = 0;
    private StringBuffer key = new StringBuffer(5);
    private int swapOrder = 0;
    private RBCollationTables ordering;
    private RuleBasedCollator owner;

    CollationElementIterator(String string, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        if (string.length() != 0) {
            NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(ruleBasedCollator.getDecomposition());
            this.text = new NormalizerBase(string, mode);
        }
    }

    CollationElementIterator(CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(ruleBasedCollator.getDecomposition());
        this.text = new NormalizerBase(characterIterator, mode);
    }

    public void reset() {
        if (this.text != null) {
            this.text.reset();
            NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition());
            this.text.setMode(mode);
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int next() {
        NormalizerBase.Mode mode;
        if (this.text == null) {
            return -1;
        }
        NormalizerBase.Mode mode2 = this.text.getMode();
        if (mode2 != (mode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(mode);
        }
        if (this.buffer != null) {
            if (this.expIndex < this.buffer.length) {
                return this.strengthOrder(this.buffer[this.expIndex++]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            if (Character.isSupplementaryCodePoint(this.swapOrder)) {
                char[] cArray = Character.toChars(this.swapOrder);
                this.swapOrder = cArray[1];
                return cArray[0] << 16;
            }
            int n = this.swapOrder << 16;
            this.swapOrder = 0;
            return n;
        }
        int n = this.text.next();
        if (n == -1) {
            return -1;
        }
        int n2 = this.ordering.getUnicodeOrder(n);
        if (n2 == -1) {
            this.swapOrder = n;
            return 0x7FFF0000;
        }
        if (n2 >= 0x7F000000) {
            n2 = this.nextContractChar(n);
        }
        if (n2 >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n2);
            this.expIndex = 0;
            n2 = this.buffer[this.expIndex++];
        }
        if (this.ordering.isSEAsianSwapping()) {
            int n3;
            if (CollationElementIterator.isThaiPreVowel(n)) {
                n3 = this.text.next();
                if (CollationElementIterator.isThaiBaseConsonant(n3)) {
                    this.buffer = this.makeReorderedBuffer(n3, n2, this.buffer, true);
                    n2 = this.buffer[0];
                    this.expIndex = 1;
                } else {
                    this.text.previous();
                }
            }
            if (CollationElementIterator.isLaoPreVowel(n)) {
                n3 = this.text.next();
                if (CollationElementIterator.isLaoBaseConsonant(n3)) {
                    this.buffer = this.makeReorderedBuffer(n3, n2, this.buffer, true);
                    n2 = this.buffer[0];
                    this.expIndex = 1;
                } else {
                    this.text.previous();
                }
            }
        }
        return this.strengthOrder(n2);
    }

    public int previous() {
        NormalizerBase.Mode mode;
        if (this.text == null) {
            return -1;
        }
        NormalizerBase.Mode mode2 = this.text.getMode();
        if (mode2 != (mode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(mode);
        }
        if (this.buffer != null) {
            if (this.expIndex > 0) {
                return this.strengthOrder(this.buffer[--this.expIndex]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            if (Character.isSupplementaryCodePoint(this.swapOrder)) {
                char[] cArray = Character.toChars(this.swapOrder);
                this.swapOrder = cArray[1];
                return cArray[0] << 16;
            }
            int n = this.swapOrder << 16;
            this.swapOrder = 0;
            return n;
        }
        int n = this.text.previous();
        if (n == -1) {
            return -1;
        }
        int n2 = this.ordering.getUnicodeOrder(n);
        if (n2 == -1) {
            this.swapOrder = 0x7FFF0000;
            return n;
        }
        if (n2 >= 0x7F000000) {
            n2 = this.prevContractChar(n);
        }
        if (n2 >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n2);
            this.expIndex = this.buffer.length;
            n2 = this.buffer[--this.expIndex];
        }
        if (this.ordering.isSEAsianSwapping()) {
            int n3;
            if (CollationElementIterator.isThaiBaseConsonant(n)) {
                n3 = this.text.previous();
                if (CollationElementIterator.isThaiPreVowel(n3)) {
                    this.buffer = this.makeReorderedBuffer(n3, n2, this.buffer, false);
                    this.expIndex = this.buffer.length - 1;
                    n2 = this.buffer[this.expIndex];
                } else {
                    this.text.next();
                }
            }
            if (CollationElementIterator.isLaoBaseConsonant(n)) {
                n3 = this.text.previous();
                if (CollationElementIterator.isLaoPreVowel(n3)) {
                    this.buffer = this.makeReorderedBuffer(n3, n2, this.buffer, false);
                    this.expIndex = this.buffer.length - 1;
                    n2 = this.buffer[this.expIndex];
                } else {
                    this.text.next();
                }
            }
        }
        return this.strengthOrder(n2);
    }

    public static final int primaryOrder(int n) {
        return (n &= 0xFFFF0000) >>> 16;
    }

    public static final short secondaryOrder(int n) {
        return (short)((n &= 0xFF00) >> 8);
    }

    public static final short tertiaryOrder(int n) {
        return (short)(n &= 0xFF);
    }

    final int strengthOrder(int n) {
        int n2 = this.owner.getStrength();
        if (n2 == 0) {
            n &= 0xFFFF0000;
        } else if (n2 == 1) {
            n &= 0xFFFFFF00;
        }
        return n;
    }

    public void setOffset(int n) {
        if (this.text != null) {
            if (n < this.text.getBeginIndex() || n >= this.text.getEndIndex()) {
                this.text.setIndexOnly(n);
            } else {
                int n2 = this.text.setIndex(n);
                if (this.ordering.usedInContractSeq(n2)) {
                    while (this.ordering.usedInContractSeq(n2)) {
                        n2 = this.text.previous();
                    }
                    int n3 = this.text.getIndex();
                    while (this.text.getIndex() <= n) {
                        n3 = this.text.getIndex();
                        this.next();
                    }
                    this.text.setIndexOnly(n3);
                }
            }
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int getOffset() {
        return this.text != null ? this.text.getIndex() : 0;
    }

    public int getMaxExpansion(int n) {
        return this.ordering.getMaxExpansion(n);
    }

    public void setText(String string) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new NormalizerBase(string, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(string);
        }
    }

    public void setText(CharacterIterator characterIterator) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new NormalizerBase(characterIterator, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(characterIterator);
        }
    }

    private static final boolean isThaiPreVowel(int n) {
        return n >= 3648 && n <= 3652;
    }

    private static final boolean isThaiBaseConsonant(int n) {
        return n >= 3585 && n <= 3630;
    }

    private static final boolean isLaoPreVowel(int n) {
        return n >= 3776 && n <= 3780;
    }

    private static final boolean isLaoBaseConsonant(int n) {
        return n >= 3713 && n <= 3758;
    }

    private int[] makeReorderedBuffer(int n, int n2, int[] nArray, boolean bl) {
        int[] nArray2;
        int n3;
        int n4 = this.ordering.getUnicodeOrder(n);
        if (n4 >= 0x7F000000) {
            n4 = bl ? this.nextContractChar(n) : this.prevContractChar(n);
        }
        int[] nArray3 = null;
        if (n4 >= 0x7E000000) {
            nArray3 = this.ordering.getExpandValueList(n4);
        }
        if (!bl) {
            n3 = n4;
            n4 = n2;
            n2 = n3;
            int[] nArray4 = nArray3;
            nArray3 = nArray;
            nArray = nArray4;
        }
        if (nArray3 == null && nArray == null) {
            nArray2 = new int[]{n4, n2};
        } else {
            n3 = nArray3 == null ? 1 : nArray3.length;
            int n5 = nArray == null ? 1 : nArray.length;
            nArray2 = new int[n3 + n5];
            if (nArray3 == null) {
                nArray2[0] = n4;
            } else {
                System.arraycopy(nArray3, 0, nArray2, 0, n3);
            }
            if (nArray == null) {
                nArray2[n3] = n2;
            } else {
                System.arraycopy(nArray, 0, nArray2, n3, n5);
            }
        }
        return nArray2;
    }

    static final boolean isIgnorable(int n) {
        return CollationElementIterator.primaryOrder(n) == 0;
    }

    private int nextContractChar(int n) {
        Vector vector = this.ordering.getContractValues(n);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n2 = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        int n3 = entryPair.entryName.length();
        NormalizerBase normalizerBase = (NormalizerBase)this.text.clone();
        normalizerBase.previous();
        this.key.setLength(0);
        int n4 = normalizerBase.next();
        while (n3 > 0 && n4 != -1) {
            if (Character.isSupplementaryCodePoint(n4)) {
                this.key.append(Character.toChars(n4));
                n3 -= 2;
            } else {
                this.key.append((char)n4);
                --n3;
            }
            n4 = normalizerBase.next();
        }
        String string = this.key.toString();
        n3 = 1;
        for (int i = vector.size() - 1; i > 0; --i) {
            entryPair = (EntryPair)vector.elementAt(i);
            if (!entryPair.fwd || !string.startsWith(entryPair.entryName) || entryPair.entryName.length() <= n3) continue;
            n3 = entryPair.entryName.length();
            n2 = entryPair.value;
        }
        while (n3 > 1) {
            n4 = this.text.next();
            n3 -= Character.charCount(n4);
        }
        return n2;
    }

    private int prevContractChar(int n) {
        Vector vector = this.ordering.getContractValues(n);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n2 = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        int n3 = entryPair.entryName.length();
        NormalizerBase normalizerBase = (NormalizerBase)this.text.clone();
        normalizerBase.next();
        this.key.setLength(0);
        int n4 = normalizerBase.previous();
        while (n3 > 0 && n4 != -1) {
            if (Character.isSupplementaryCodePoint(n4)) {
                this.key.append(Character.toChars(n4));
                n3 -= 2;
            } else {
                this.key.append((char)n4);
                --n3;
            }
            n4 = normalizerBase.previous();
        }
        String string = this.key.toString();
        n3 = 1;
        for (int i = vector.size() - 1; i > 0; --i) {
            entryPair = (EntryPair)vector.elementAt(i);
            if (entryPair.fwd || !string.startsWith(entryPair.entryName) || entryPair.entryName.length() <= n3) continue;
            n3 = entryPair.entryName.length();
            n2 = entryPair.value;
        }
        while (n3 > 1) {
            n4 = this.text.previous();
            n3 -= Character.charCount(n4);
        }
        return n2;
    }
}

