/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Serial;
import com.macromedia.generator.api.peer.JPEGBuilderPeer;

public class JPEGBuilder
extends GenObject {
    public JPEGBuilder() throws GeneratorApiException {
        this.peer = JPEGBuilderPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected JPEGBuilder(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            JPEGBuilderPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            JPEGBuilderPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setSerial(Serial serial) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = serial != null ? serial.peer : 0;
        JPEGBuilderPeer.SetSerial(this.peer, n);
    }

    public void setProgressive(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = JPEGBuilderPeer.SetProgressive(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting progressive JPEG flag");
        }
    }

    public void setQuality(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = JPEGBuilderPeer.SetQuality(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting JPEG quality");
        }
    }

    public void setDimensions(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = JPEGBuilderPeer.SetDimensions(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error setting dimensions for gif");
        }
    }

    public void setExactFit(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = JPEGBuilderPeer.SetExactFit(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting exact fit JPEG flag");
        }
    }

    public void setBackgroundColor(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = JPEGBuilderPeer.SetBackgroundColor(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error setting background color");
        }
    }

    public void build(Buffer buffer, Buffer buffer2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (buffer.peer == 0 || buffer2.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = JPEGBuilderPeer.Build(this.peer, buffer.peer, buffer2.peer);
        if (n == 0) {
            throw new GeneratorApiException("error building the JPEG buffer");
        }
    }
}

