/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Color;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.peer.LineStylePeer;

public class LineStyle
extends GenObject {
    public LineStyle() throws GeneratorApiException {
        this.peer = LineStylePeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected LineStyle(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            LineStylePeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            LineStylePeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setRgb(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = LineStylePeer.SetRgb(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting rgb");
        }
    }

    public void setColor(Color color) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = LineStylePeer.SetColor(this.peer, color.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting color");
        }
    }

    public void setWidth(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = LineStylePeer.SetWidth(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting width");
        }
    }
}

