/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiRuntimeException;
import com.macromedia.generator.api.peer.SerialPeer;

public class Serial
extends GenObject {
    public Serial() {
        this.peer = SerialPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("unable to create peer");
        }
    }

    protected Serial(int n) {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
    }

    public void setPeer(int n) {
        this.peer = n;
    }

    protected void finalize() throws Throwable {
        String string = System.getProperty("com.macromedia.generator.offline", "0");
        if (string.equalsIgnoreCase("0")) {
            if (this.peer != 0) {
                SerialPeer.Release(this.peer);
            }
            this.peer = 0;
        }
    }

    public void release() {
        if (this.peer != 0) {
            SerialPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void reset() {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        SerialPeer.Reset(this.peer);
    }

    public String getFirstName() {
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetFirstName(this.peer, stringArray);
        if (n == 0) {
            stringArray[0] = null;
        }
        return stringArray[0];
    }

    public String getMiddleName() {
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetMiddleName(this.peer, stringArray);
        if (n == 0) {
            stringArray[0] = null;
        }
        return stringArray[0];
    }

    public String getLastName() {
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetLastName(this.peer, stringArray);
        if (n == 0) {
            stringArray[0] = null;
        }
        return stringArray[0];
    }

    public String getOrganization() {
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetOrganization(this.peer, stringArray);
        if (n == 0) {
            stringArray[0] = null;
        }
        return stringArray[0];
    }

    public String getServerNumber() {
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetServerNumber(this.peer, stringArray);
        if (n == 0) {
            stringArray[0] = null;
        }
        return stringArray[0];
    }

    public String getSerialNumber() {
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetSerialNumber(this.peer, stringArray);
        if (n == 0) {
            stringArray[0] = null;
        }
        return stringArray[0];
    }

    public boolean getPublished() {
        boolean[] blArray = new boolean[]{true};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetPublished(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting serial publish setting");
        }
        return blArray[0];
    }

    public boolean getLimited() {
        boolean[] blArray = new boolean[]{true};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetLimited(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting limited setting");
        }
        return blArray[0];
    }

    public void setFirstName(String string) {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            string = "";
        }
        if ((n = SerialPeer.SetFirstName(this.peer, string)) == 0) {
            throw new GeneratorApiRuntimeException("error setting first name value");
        }
    }

    public void setMiddleName(String string) {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            string = "";
        }
        if ((n = SerialPeer.SetMiddleName(this.peer, string)) == 0) {
            throw new GeneratorApiRuntimeException("error setting middle name value");
        }
    }

    public void setLastName(String string) {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            string = "";
        }
        if ((n = SerialPeer.SetLastName(this.peer, string)) == 0) {
            throw new GeneratorApiRuntimeException("error setting last name value");
        }
    }

    public void setOrganization(String string) {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            string = "";
        }
        if ((n = SerialPeer.SetOrganization(this.peer, string)) == 0) {
            throw new GeneratorApiRuntimeException("error setting organization value");
        }
    }

    public void setServerNumber(String string) {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            string = "";
        }
        if ((n = SerialPeer.SetServerNumber(this.peer, string)) == 0) {
            throw new GeneratorApiRuntimeException("error setting server number value");
        }
    }

    public void setSerialNumber(String string) {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            string = "";
        }
        if ((n = SerialPeer.SetSerialNumber(this.peer, string)) == 0) {
            throw new GeneratorApiRuntimeException("error setting serial number value");
        }
    }

    public void setPublished(boolean bl) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.SetPublished(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error setting serial publish settings");
        }
    }

    public boolean getSerialNumberOK() {
        boolean[] blArray = new boolean[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetSerialNumberOK(this.peer, blArray);
        if (n == 0) {
            blArray[0] = false;
        }
        return blArray[0];
    }

    public int getAPICall(boolean bl) {
        int[] nArray = new int[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = SerialPeer.GetSerialNumberExpires(this.peer, nArray, bl);
        if (n == 0) {
            nArray[0] = 0;
        }
        return nArray[0];
    }

    public int flush(boolean bl) {
        return this.getAPICall(bl);
    }
}

