/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.protocol.fgjava;

import com.macromedia.generator.utils.GenInfo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FgjavaURLConnection
extends URLConnection {
    InputStream inputStream;
    protected static Hashtable loadedClasses;
    private GenInfo mGenInfo = null;

    FgjavaURLConnection(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        String string = this.url.getFile();
        String string2 = FgjavaURLConnection.parseClassString(string);
        if (string2.charAt(0) == '/') {
            string2 = string2.substring(1, string2.length());
        }
        Hashtable hashtable = FgjavaURLConnection.parseQueryString(string);
        this.inputStream = this.processJavaQuery(string2, hashtable);
        if (this.inputStream == null) {
            throw new IOException("Error processing Java stream in URL: " + this.url.toExternalForm());
        }
        this.connected = true;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    private static String parseClassString(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n = string.indexOf(63);
        if (n == -1) {
            n = string.length();
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    private static Hashtable parseQueryString(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = string.indexOf(63);
        if (n > -1) {
            String string2 = string.substring(n + 1, string.length());
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                n = string3.indexOf(61);
                if (n <= 0) continue;
                String string4 = FgjavaURLConnection.parseName(string3.substring(0, n), stringBuffer);
                String string5 = FgjavaURLConnection.parseName(string3.substring(n + 1, string3.length()), stringBuffer);
                hashtable.put(string4, string5);
            }
        }
        return hashtable;
    }

    private static String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    n += 2;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static synchronized Class loadJavaClass(String string) throws IOException {
        Class<?> clazz;
        if (loadedClasses == null) {
            loadedClasses = new Hashtable();
        }
        try {
            clazz = (Class<?>)loadedClasses.get(string);
            if (clazz == null) {
                clazz = Class.forName(string);
                loadedClasses.put(string, clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class loading failed for class " + string + ": ClassNotFoundException");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class loading failed for class " + string + ": ClassCastException");
        }
        catch (Exception exception) {
            throw new IOException("Class loading failed for class " + string + ": Exception");
        }
        return clazz;
    }

    private InputStream processJavaQuery(String string, Hashtable hashtable) throws IOException {
        InputStream inputStream = null;
        Class clazz = FgjavaURLConnection.loadJavaClass(string);
        if (clazz != null && (inputStream = this.invokeExtendedForm(clazz, hashtable)) == null) {
            try {
                Class[] classArray = new Class[]{Class.forName("java.util.Hashtable")};
                Method method = clazz.getMethod("getStream", classArray);
                Object[] objectArray = new Object[]{hashtable};
                inputStream = (InputStream)method.invoke(null, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Class loading failed for class " + string + ": ClassNotFoundException");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException("Class loading failed for class " + string + ": NoSuchMethodException");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Class loading failed for class " + string + ": IllegalAccessException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Class loading failed for class " + string + ": IllegalArgumentException");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException("Class loading failed for class " + string + ": InvocationTargetException");
            }
        }
        return inputStream;
    }

    private InputStream invokeExtendedForm(Class clazz, Hashtable hashtable) {
        InputStream inputStream;
        block5: {
            inputStream = null;
            try {
                try {
                    Class[] classArray = new Class[]{Class.forName("java.util.Hashtable"), Class.forName("com.macromedia.generator.utils.GenInfo")};
                    Method method = clazz.getMethod("getStreamEx", classArray);
                    Object[] objectArray = new Object[]{hashtable, this.mGenInfo};
                    inputStream = (InputStream)method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    Object var8_10 = null;
                    break block5;
                }
                catch (Error error) {
                    Object var8_11 = null;
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                throw throwable;
            }
        }
        return inputStream;
    }

    public void setGenInfo(GenInfo genInfo) {
        this.mGenInfo = genInfo;
    }
}

