#ifndef _MM_JSAPI_H_
#define _MM_JSAPI_H_


/*****************************************************************************
 * Public data types
 ****************************************************************************/

typedef struct JSContext JSContext;
typedef struct JSObject JSObject;
typedef long jsval;
#ifndef JSBool
typedef long JSBool;
#endif

#ifndef jschar
typedef unsigned short jschar;
#endif

typedef JSBool (*JSNative)(JSContext *cx, JSObject *obj, unsigned int argc, 
    jsval *argv, jsval *rval); 

/* Possible values for JSBool */
#define JS_TRUE 1
#define JS_FALSE 0

// Attribute values Get/SetConfigFileAttributes
//
#define MM_FILEATTR_NORMAL	0x00	/* Normal file - No read/write restrictions */
#define MM_FILEATTR_RDONLY	0x01	/* Read only file */
#define MM_FILEATTR_HIDDEN	0x02	/* Hidden file */
#define MM_FILEATTR_SYSTEM	0x04	/* System file */
#define MM_FILEATTR_SUBDIR	0x10	/* Subdirectory */


/*****************************************************************************
 * Public functions
 ****************************************************************************/

/* JSBool JS_DefineFunction(char *name, JSNative call, unsigned int nargs) */
#define JS_DefineFunction(n, c, a) \
    (mmEnv.defineFunction ? (*(mmEnv.defineFunction))(mmEnv.libObj, n, c, a) \
                          : JS_FALSE)

/* char *JS_ValueToString(JSContext *cx, jsval v, unsigned int *pLength) */
#define JS_ValueToString(c, v, l) \
    (mmEnv.valueToString  ? (*(mmEnv.valueToString))(c, v, l) : (char *)0)

/* char *JS_ValueToUCString(JSContext *cx, jsval v, unsigned int *pLength) */
#define JS_ValueToUCString(c, v, l) \
    (mmEnv.valueToUCString  ? (*(mmEnv.valueToUCString))(c, v, l) : (jschar *)0)

/* JSBool JS_ValueToInteger(JSContext *cx, jsval v, long *lp); */
#define JS_ValueToInteger(c, v, l) \
    (mmEnv.valueToInteger ? (*(mmEnv.valueToInteger))(c, v, l) : JS_FALSE)

/* JSBool JS_ValueToDouble(JSContext *cx, jsval v, double *dp); */
#define JS_ValueToDouble(c, v, d) \
    (mmEnv.valueToDouble  ? (*(mmEnv.valueToDouble))(c, v, d) : JS_FALSE)

/* JSBool JS_ValueToBoolean(JSContext *cx, jsval v, JSBool *bp); */
#define JS_ValueToBoolean(c, v, b) \
    (mmEnv.valueToBoolean ? (*(mmEnv.valueToBoolean))(c, v, b) : JS_FALSE)

/* JSBool JS_ValueToObject(JSContext *cx, jsval v, JSObject **op); */
#define JS_ValueToObject(c, v, o) \
    (mmEnv.valueToObject  ? (*(mmEnv.valueToObject))(c, v, o) : JS_FALSE)

/* JSBool JS_StringToValue(JSContext *cx, char *bytes, uint sz, jsval *vp); */
#define JS_StringToValue(c, b, s, v) \
    (mmEnv.stringToValue  ? (*(mmEnv.stringToValue))(c, b, s, v) : JS_FALSE)

/* JSBool JS_UCStringToValue(JSContext *cx, char *bytes, uint sz, jsval *vp); */
#define JS_UCStringToValue(c, b, s, v) \
    (mmEnv.ucstringToValue  ? (*(mmEnv.ucstringToValue))(c, b, s, v) : JS_FALSE)

/* JSBool JS_DoubleToValue(JSContext *cx, double dv, jsval *vp); */
#define JS_DoubleToValue(c, d, v) \
    (mmEnv.doubleToValue  ? (*(mmEnv.doubleToValue))(c, d, v) : JS_FALSE)

/* jsval JS_IntegerToValue(long lv); */
#define JS_IntegerToValue(lv)       (((jsval)(lv) << 1) | 0x1)

/* jsval JS_BooleanToValue(JSBool bv); */
#define JS_BooleanToValue(bv)       (((jsval)(bv) << 3) | 0x6)

/* jsval JS_ObjectToValue(JSObject *obj); */
#define JS_ObjectToValue(ov)		((jsval)(ov))

/* char *JS_ObjectType(JSObject *obj); */
#define JS_ObjectType(o) \
    (mmEnv.objectType     ? (*(mmEnv.objectType))(o) : (char *)0)

/* JSObject *JS_NewArrayObject(JSContext *cx, unsigned int length, jsval *v) */
#define JS_NewArrayObject(c, l, v) \
	(mmEnv.newArrayObject ? (*(mmEnv.newArrayObject))(c, l, v) : (JSObject *)0)

/* long JS_GetArrayLength(JSContext *cx, JSObject *obj) */
#define JS_GetArrayLength(c, o) \
	(mmEnv.getArrayLength ? (*(mmEnv.getArrayLength))(c, o) : -1)

/* JSBool JS_GetElement(JSContext *cx, JSObject *obj, jsint idx, jsval *vp) */
#define JS_GetElement(c, o, i, v) \
    (mmEnv.getElement     ? (*(mmEnv.getElement))(c, o, i, v) : JS_FALSE)

/* JSBool JS_SetElement(JSContext *cx, JSObject *obj, jsint idx, jsval *vp) */
#define JS_SetElement(c, o, i, v) \
    (mmEnv.setElement     ? (*(mmEnv.setElement))(c, o, i, v) : JS_FALSE)

/* JSBool JS_ExecuteScript(JSContext *cx, JSObject *obj, char *script,
 *     unsigned int sz, jsval *rval) */
#define JS_ExecuteScript(c, o, s, z, r) \
    (mmEnv.executeScript  ? (*(mmEnv.executeScript))(c, o, s, z, __FILE__, \
        __LINE__, r) : JS_FALSE)

/* JSBool JS_ExecuteUCScript(JSContext *cx, JSObject *obj, char *script,
 *     unsigned int sz, jsval *rval) */
#define JS_ExecuteUCScript(c, o, s, z, r) \
    (mmEnv.executeUCScript  ? (*(mmEnv.executeUCScript))(c, o, s, z, __FILE__, \
        __LINE__, r) : JS_FALSE)

/* JSBool JS_ReportError(JSContext *cx, char *error, unsigned int sz) */
#define JS_ReportError(c, e, s) \
    (mmEnv.reportError    ? (*(mmEnv.reportError))(c, e, s) : JS_FALSE)

/*****************************************************************************
 * ConfigFile functions
 * Use the following file functions in place of system calls if any of 
 * the file operations may act on files in the Dreamweaver configuration 
 * folder. On multiple user systems, such as Windows XP and Mac OSX, 
 * these functions will always work even if the user does not have write 
 * permission in the configuration folder. See Extending Dreamweaver for 
 * more info.
 *
 * Note: you can use these functions for non-configuration files as well. 
 ****************************************************************************/

/* JSObject * MM_GetConfigFolderList (JSContext *cx, char *fileUrl, char *constraints = NULL) */
#define MM_GetConfigFolderList(c, f, cn) \
    (mmEnv.getConfigFolderList    ? (*(mmEnv.getConfigFolderList))(c, f, cn) : (JSObject *)0)

/* JSObject * MM_GetUCConfigFolderList (JSContext *cx, char *fileUrl, char *constraints = NULL) */
#define MM_GetUCConfigFolderList(c, f, cn) \
    (mmEnv.getUCConfigFolderList    ? (*(mmEnv.getUCConfigFolderList))(c, f, cn) : (JSObject *)0)

/* JSBool MM_ConfigFileExists (char *fileURL) */
#define MM_ConfigFileExists(f) \
    (mmEnv.configFileExists    ? (*(mmEnv.configFileExists))(f) : JS_FALSE)

/* JSBool MM_UCConfigFileExists (char *fileURL) */
#define MM_UCConfigFileExists(f) \
    (mmEnv.ucconfigFileExists    ? (*(mmEnv.ucconfigFileExists))(f) : JS_FALSE)

/* int MM_OpenConfigFile (char *fileURL, char *mode)
	- note: mode can be "read" or "write", "write" implies create 
	- note: on windows, the handle you get back is a MS C Runtime file
			handle opened from msvcrt.dll. This is for backwards 
			compatibility, as Dreamweaver no longer links against this
			dll. The function MM_OpenUCConfigFile() is preferred to 
			get a file handle.
	- note: on mac, the handle is the forkRefNum result from FSOpenFork() 
			with the data fork of the file*/
#define MM_OpenConfigFile(f, m) \
    (mmEnv.openConfigFile    ? (*(mmEnv.openConfigFile))(f, m) : JS_FALSE)

/* long MM_OpenUCConfigFile (char *fileURL, char *mode)
	- note: mode can be "read" or "write", "write" implies create
	- note: on windows, the handle you get back is an osfhandle 
			in order to use it with the MS Runtime Library use _open_osfhandle()
	- note: on mac, the handle is the forkRefNum result from FSOpenFork() 
			with the data fork of the file*/
#define MM_OpenUCConfigFile(f, m) \
    (mmEnv.openUCConfigFile    ? (*(mmEnv.openUCConfigFile))(f, m) : JS_FALSE)

/* JSObject * MM_GetConfigFileAttributes (char *fileUrl, unsigned long* attrs, unsigned long* filesize, unsigned long* modtime, unsigned long* createtime) 
	- return string with some or all characters "DRHS", or NULL if error */
#define MM_GetConfigFileAttributes(f, a, s, m, c) \
    (mmEnv.getConfigFileAttributes    ? (*(mmEnv.getConfigFileAttributes))(f, a, s, m, c) : JS_FALSE)

/* JSObject * MM_GetUCConfigFileAttributes (char *fileUrl, unsigned long* attrs, unsigned long* filesize, unsigned long* modtime, unsigned long* createtime) 
	- return string with some or all characters "DRHS", or NULL if error */
#define MM_GetUCConfigFileAttributes(f, a, s, m, c) \
    (mmEnv.getUCConfigFileAttributes    ? (*(mmEnv.getUCConfigFileAttributes))(f, a, s, m, c) : JS_FALSE)

/* JSBool MM_SetConfigFileAttributes (char *fileURL, unsigned long attrs) */
#define MM_SetConfigFileAttributes(f, a) \
    (mmEnv.setConfigFileAttributes    ? (*(mmEnv.setConfigFileAttributes))(f, a) : JS_FALSE)

/* JSBool MM_SetUCConfigFileAttributes (char *fileURL, unsigned long attrs) */
#define MM_SetUCConfigFileAttributes(f, a) \
    (mmEnv.setUCConfigFileAttributes    ? (*(mmEnv.setUCConfigFileAttributes))(f, a) : JS_FALSE)

/* JSBool MM_CreateConfigFolder (char *fileURL) */
#define MM_CreateConfigFolder(f) \
    (mmEnv.createConfigFolder    ? (*(mmEnv.createConfigFolder))(f) : JS_FALSE)

/* JSBool MM_CreateUCConfigFolder (char *fileURL) */
#define MM_CreateUCConfigFolder(f) \
    (mmEnv.createUCConfigFolder    ? (*(mmEnv.createUCConfigFolder))(f) : JS_FALSE)

/* JSBool MM_RemoveConfigFolder (char *fileURL) */
#define MM_RemoveConfigFolder(f) \
    (mmEnv.removeConfigFolder    ? (*(mmEnv.removeConfigFolder))(f) : JS_FALSE)

/* JSBool MM_RemoveUCConfigFolder (char *fileURL) */
#define MM_RemoveUCConfigFolder(f) \
    (mmEnv.removeUCConfigFolder    ? (*(mmEnv.removeUCConfigFolder))(f) : JS_FALSE)

/* JSBool MM_DeleteConfigFile (char *fileURL) */
#define MM_DeleteConfigFile(f) \
    (mmEnv.deleteConfigFile    ? (*(mmEnv.deleteConfigFile))(f) : JS_FALSE)

/* JSBool MM_DeleteUCConfigFile (char *fileURL) */
#define MM_DeleteUCConfigFile(f) \
    (mmEnv.deleteUCConfigFile    ? (*(mmEnv.deleteUCConfigFile))(f) : JS_FALSE)

/* JSBool MM_ReadUCConfigFile (JSContext *cx, char *fileURL, char* charset, jsval *rval) */
#define MM_ReadUCConfigFile(cx, f, c, v) \
    (mmEnv.readUCConfigFile    ? (*(mmEnv.readUCConfigFile))(cx, f, c, v) : JS_FALSE)

/* JSBool MM_WriteUCConfigFile (char *fileURL, char *mode, char *text, char* charset, jsval *rval) */
#define MM_WriteUCConfigFile(f, m, t, c, v) \
    (mmEnv.writeUCConfigFile    ? (*(mmEnv.writeUCConfigFile))(f, m, t, c, v) : JS_FALSE)
    
    /* JSBool MM_ResolveUCConfigFileURL (const jschar * inFileUrl, jschar* outFileUrl, unsigned int outFileLength) */
#define MM_ResolveUCConfigFilePath(ip, op, l) \
    (mmEnv.resolveUCConfigFilePath    ? (*(mmEnv.resolveUCConfigFilePath))(ip, op, l) : JS_FALSE)

/*****************************************************************************
 * Private data types, macros, and globals
 ****************************************************************************/

#include "mm_jsapi_environment.h"

extern MM_Environment mmEnv;

// Declare the external entry point and linkage
#ifdef _WIN32
#   ifndef _MAC  
    // Windows
    __declspec( dllexport ) void MM_InitWrapper( MM_Environment *env, unsigned int envSize );
#   else
    // Mac with MSVC++ Win32 portability lib
    extern void MM_InitWrapper( MM_Environment *env, unsigned int envSize );
#   endif
#else
    // Codewarrior
#   pragma export on    
    extern void MM_InitWrapper( MM_Environment *env, unsigned int envSize );
#   pragma export off
#endif


#define MM_STATE                                                             	\
    /* Definitions of global variables */                                    	\
    MM_Environment mmEnv;                                                    	\
																			 							\
	 void																	 							\
  	 MM_InitWrapper(MM_Environment *env, unsigned int envSize)                	\
    {																		 							\
		extern void MM_Init();												 					\
																			 							\
		char **envPtr = (char **)env;										 					\
		char **mmPtr =  (char **)(&mmEnv);									 				\
		char **envEnd = (char **)((char *)envPtr + envSize);				 			\
		char **mmEnd =  (char **)((char *)mmPtr  + sizeof(MM_Environment));  	\
																			 							\
		/* Copy fields from env to mmEnv, one pointer at a time */			 		\
		while (mmPtr < mmEnd && envPtr < envEnd)							 				\
			*mmPtr++ = *envPtr++;											 					\
																			 							\
      /* If env doesn't define all of mmEnv's fields, set extras to NULL */	\
		while (mmPtr < mmEnd)												 					\
			*mmPtr++ = (char *)0;											 					\
                                                                             	\
      /* Call user's MM_Init function */                                   	\
      MM_Init();                                                           	\
    }                                                                        	\
                                                                             
#endif /* _MM_JSAPI_H_ */