/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function LocalWorkflowStorage(/*[String]*/ inBasePath)
{
	var workflowMap = {};
	var workflowList = [];
		
	// initialize
	(function()
	{
		var workflowFolder = inBasePath;
		
		if (isValidProperty(workflowFolder))
		{
			if (workflowFolder.lastIndexOf('/') != workflowFolder.length-1)
			{
				workflowFolder += '/';
			}

			// retrieve workflow file names from folder
			//
			var wfFiles = [];
		
			var res = cep.fs.readdir(workflowFolder);
		
			if (isValidProperty(res) && res.err == cep.fs.NO_ERROR)
			{
				for( var f=0; f<res.data.length; f++)
				{
					if (res.data[f].lastIndexOf('.wfd') == res.data[f].length - 4)
					{
						wfFiles.push(workflowFolder + res.data[f]);
					}
				}
			}
		
			// create Workflow objects
			//
			for (var w=0; w<wfFiles.length; w++)
			{
				var res = cep.fs.readFile(wfFiles[w]);
			
				if (isValidProperty(res) && res.err == cep.fs.NO_ERROR)
				{
					var wf = Workflow.create(res.data);
				
					if (isValidProperty(wf))
					{
						workflowMap[wf.id] = wf;
						workflowList.push(wf);
					}
				}
			}
		}
	})();

	//////////////////////////////////////////////////////////////////////////////
	//
	// Return an array consisting of workflows
	//
	this.getWorkflows = function()
	{
		dbgLogWorkflows("LocalWorkflowStorge.getWorkflows", "", workflowList);

		var job = new Job();
		job.setResult(workflowList);
		return job;
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Return Workflow object for the given workflow id inID
	//
	this.getWorkflow = function(/*[string]*/ inID)
	{
		var job = new Job();
		var value = null;

		if (isValidProperty(workflowMap[inID]))
		{
			value = workflowMap[inID];
			job.setResult(workflowMap[inID]);
		}
		else
		{
			job.setError("LocalWorkflowStorage.getWorkflow: Not available, workflow ID: " + inID);
			dbglogError(job.getError());
		}
		
		dbgLogWorkflows("LocalWorkflowStorage.getWorkflow", "", [value]);

		return job;
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Add a Workflow
	//
	this.addWorkflow = function(/*[Workflow]*/ inWorkflow)
	{
		if (isValidProperty(inWorkflow) && isValidProperty(inWorkflow.id))
		{
			dbgLogWorkflows("LocalWorkflowStorage.addWorkflow", "", [inWorkflow]);
			workflowMap[inWorkflow.id] = inWorkflow;
			workflowList.push(inWorkflow);
		}
	}
}

