/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function MultiWorkflowStorage(/*[Array]*/ inWorkflowBasePaths, /*[String]*/ inBaseURL, /*[String]*/ inCacheBasePath)
{
	var localStorage = [];
	var remoteStorage = ((isValidProperty(inBaseURL) && inBaseURL.length) ? new RemoteWorkflowStorage(inCacheBasePath, inBaseURL) : null);
 
	//////////////////////////////////////////////////////////////////////////////
	//
	// Return an array consisting of workflows
	//
	this.getWorkflows = function()
	{
		var ret = new CompoundJob(function(/*[Array]*/ inResult)
		{
			var result = [];

			if (inResult.length > 0)
			{
				// each single result is an array, the returned result should be
				// a merged array
				//
				var allResults = inResult[0];
				if (inResult.length > 1)
				{
					for (var i=1; i<inResult.length; i++)
					{
						allResults = allResults.concat(inResult[i]);
					}
				}

				for (var i = 0; i < allResults.length; i++)
				{
					var doInsert = true;

					for (var o = 0; o < result.length; o++)
					{
						doInsert = isValidProperty(allResults[i]);

						if (doInsert && result[o].id == allResults[i].id)
						{
							doInsert = false;
							break;
						}
					}

					if (doInsert)
					{
						result.push(allResults[i]);
					}
				}
			}

			return result;
		});

		forEach(localStorage, function(storage)
		{
			ret.addJob(storage.getWorkflows());
		});

		if(isValidProperty(remoteStorage))
		{
			ret.addJob(remoteStorage.getWorkflows());
		}

		return ret;
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Return Workflow object for the given workflow id inID
	//
	this.getWorkflow = function(/*[string]*/ inID, /*[Function]*/ inCallback)
	{
		var ret = null;
		var workflow = null;
		
		for (var index=0; index<localStorage.length && !isValidProperty(ret); index++)
		{
			var job = localStorage[index].getWorkflow(inID);

			if (job.isStatus(IJob.STATUS_SUCCESS))
			{
				ret = job;
				try
				{
					dbgLogWorkflows("MultiWorkflowStorage.getWorkflow", "Local workflow", [job.getResult()]);
				}
				catch(exc)
				{
					exclog(exc);
				}
			}
		}

		if (!isValidProperty(ret) && isValidProperty(remoteStorage))
		{
			ret = remoteStorage.getWorkflow(inID);
			dbglogInfo('(MultiWorkflowStorage) Requesting remote workflow id: ' + inID);
		}

		return ret;
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Debug logging
	//
	function dbgLogWorkflows(/*[String]*/ inFunction, /*[String]*/ inText, /*[Array]*/ inWorkflows)
	{
		var idStr = '';

		forEach(inWorkflows, function(workflow)
		{
			if (isValidProperty(workflow))
			{
				if (isValidProperty(workflow.name))
				{
					idStr += workflow.name + ' ';
				}
				if (isValidProperty(workflow.id))
				{
					idStr += '[' + workflow.id + ']';
				}
			}
			idStr += ', ';
		});

		dbglogInfo('(' + inFunction + ') ' + inText + ': ' + idStr);
	}

	// initialize /////////////////////////////////////////////////////////////////

	function initialize()
	{
		forEach(inWorkflowBasePaths, function(path)
		{
			localStorage.push(new LocalWorkflowStorage(path));
		});
	}
	initialize();
}