/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

var currentIndicators = [];

//////////////////////////////////////////////////////////////////////////////
//
// Display IndicatorOverlay window
//
function displayUIIndicator(/*[String]*/ inCtrlPath, /*[String]*/ inText, /*[String]*/ inDirection)
{
	var error = false;
	var data = null;

	var direction = IndicatorOverlay.ANCHOR_RIGHT_EDGE;

	switch (inDirection)
	{
		case 'left':	direction = IndicatorOverlay.ANCHOR_RIGHT_EDGE; break;
		case 'right':	direction = IndicatorOverlay.ANCHOR_LEFT_EDGE; break;
		case 'top':		direction = IndicatorOverlay.ANCHOR_BOTTOM_EDGE; break;
		case 'bottom':	direction = IndicatorOverlay.ANCHOR_TOP_EDGE; break;
	}

	var indicator = null;

	try
	{
		indicator = new IndicatorOverlay(inCtrlPath, direction, inText, true, true, true);
	}
	catch(e)
	{
		error = true;
		data = '"Controll Path does not exists: ' + inCtrlPath + '"';
	}

	try
	{
		if (isValidProperty(indicator))
		{
			indicator.show();
			currentIndicators.push(indicator);
		}
	}
	catch(e)
	{
		error = true;
		data = '"' + e.toString() + '"';
	}
	
	return createResultJSON(error, data);
}

//////////////////////////////////////////////////////////////////////////////
//
// Display IndicatorOverlay window
//
function displayMenuIndicator(/*[String]*/ inMenu)
{
	var error = false;
	var data = null;
	
	try
	{
		var support = new OnboardingSupport();
		support.indicateMainMenuItem(inMenu);
	}
	catch(e)
	{
		error = true;
		data = '"' + e.toString() + '"';
	}
	
	return createResultJSON(error, data);
}

//////////////////////////////////////////////////////////////////////////////
//
// Hide (and destroy) IndicatorOverlay window
//
function hideAllIndicator()
{
	var error = false;
	var data = null;

	try
	{
		data = currentIndicators.length;

		if (currentIndicators.length)
		{
			while (currentIndicators.length > 0)
			{
				var indicator = currentIndicators.pop();
				indicator.hide();
			}

			currentIndicators = [];
		}
	}
	catch(exc)
	{
		error = true;
		data = '"' + exc.toString() + '"';
	}

	return createResultJSON(error, data);
}
