/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyResponse;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestInvalidateApiKeyAction
extends SecurityBaseRestHandler {
    static final ConstructingObjectParser<InvalidateApiKeyRequest, Void> PARSER = new ConstructingObjectParser("invalidate_api_key", a -> new InvalidateApiKeyRequest((String)a[0], (String)a[1], (String)a[2], (String)a[3], a[4] == null ? false : (Boolean)a[4], a[5] == null ? null : ((List)a[5]).toArray(new String[0])));

    public RestInvalidateApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, "/_security/api_key"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            InvalidateApiKeyRequest invalidateApiKeyRequest = (InvalidateApiKeyRequest)PARSER.parse(parser, null);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)InvalidateApiKeyAction.INSTANCE, (ActionRequest)invalidateApiKeyRequest, (ActionListener)new RestBuilderListener<InvalidateApiKeyResponse>(channel){

                public RestResponse buildResponse(InvalidateApiKeyResponse invalidateResp, XContentBuilder builder) throws Exception {
                    invalidateResp.toXContent(builder, (ToXContent.Params)this.channel.request());
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    public String getName() {
        return "xpack_security_invalidate_api_key";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("realm_name", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("username", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("id", new String[0]).withAllDeprecated("ids"));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("name", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("owner", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("ids", new String[0]));
    }
}

