/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GroovyScriptedTask
extends Task {
    static final String GROOVY_SCRIPTED_TASK_CLASS = "com.unboundid.directory.sdk.extensions.GroovyScriptedTask";
    private static final String ATTR_GROOVY_SCRIPTED_TASK_CLASS = "ds-scripted-task-class";
    private static final String ATTR_GROOVY_SCRIPTED_TASK_ARGUMENT = "ds-scripted-task-argument";
    private static final String OC_GROOVY_SCRIPTED_TASK = "ds-groovy-scripted-task";
    static final TaskProperty PROPERTY_TASK_CLASS = new TaskProperty("ds-scripted-task-class", TaskMessages.INFO_DISPLAY_NAME_GROOVY_SCRIPTED_TASK_CLASS.get(), TaskMessages.INFO_DESCRIPTION_GROOVY_SCRIPTED_TASK_CLASS.get(), String.class, true, false, false);
    static final TaskProperty PROPERTY_TASK_ARG = new TaskProperty("ds-scripted-task-argument", TaskMessages.INFO_DISPLAY_NAME_GROOVY_SCRIPTED_TASK_ARG.get(), TaskMessages.INFO_DESCRIPTION_GROOVY_SCRIPTED_TASK_ARG.get(), String.class, false, true, false);
    private static final long serialVersionUID = -1354970323227263273L;
    private final List<String> taskArguments;
    private final String taskClassName;

    public GroovyScriptedTask() {
        this.taskArguments = null;
        this.taskClassName = null;
    }

    public GroovyScriptedTask(String taskID, String taskClassName, List<String> taskArguments) {
        this(taskID, taskClassName, taskArguments, null, null, null, null, null);
    }

    public GroovyScriptedTask(String taskID, String taskClassName, List<String> taskArguments, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        this(taskID, taskClassName, taskArguments, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public GroovyScriptedTask(String taskID, String taskClassName, List<String> taskArguments, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) {
        super(taskID, GROOVY_SCRIPTED_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(taskClassName);
        this.taskClassName = taskClassName;
        this.taskArguments = taskArguments == null ? Collections.emptyList() : Collections.unmodifiableList(taskArguments);
    }

    public GroovyScriptedTask(Entry entry) throws TaskException {
        super(entry);
        this.taskClassName = entry.getAttributeValue(ATTR_GROOVY_SCRIPTED_TASK_CLASS);
        if (this.taskClassName == null) {
            throw new TaskException(TaskMessages.ERR_GROOVY_SCRIPTED_TASK_NO_CLASS.get(this.getTaskEntryDN()));
        }
        String[] args = entry.getAttributeValues(ATTR_GROOVY_SCRIPTED_TASK_ARGUMENT);
        this.taskArguments = args == null || args.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(args));
    }

    public GroovyScriptedTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(GROOVY_SCRIPTED_TASK_CLASS, properties);
        String className = null;
        String[] args = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_GROOVY_SCRIPTED_TASK_CLASS)) {
                className = GroovyScriptedTask.parseString(p, values, null);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_GROOVY_SCRIPTED_TASK_ARGUMENT)) continue;
            args = GroovyScriptedTask.parseStrings(p, values, null);
        }
        if (className == null) {
            throw new TaskException(TaskMessages.ERR_GROOVY_SCRIPTED_TASK_NO_CLASS.get(this.getTaskEntryDN()));
        }
        this.taskClassName = className;
        this.taskArguments = args == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(args));
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_GROOVY_SCRIPTED_TASK.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_GROOVY_SCRIPTED_TASK.get();
    }

    public String getGroovyScriptedTaskClassName() {
        return this.taskClassName;
    }

    public List<String> getGroovyScriptedTaskArguments() {
        return this.taskArguments;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_GROOVY_SCRIPTED_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(2);
        attrList.add(new Attribute(ATTR_GROOVY_SCRIPTED_TASK_CLASS, this.taskClassName));
        if (!this.taskArguments.isEmpty()) {
            attrList.add(new Attribute(ATTR_GROOVY_SCRIPTED_TASK_ARGUMENT, this.taskArguments));
        }
        return attrList;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_TASK_CLASS, PROPERTY_TASK_ARG));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(2);
        props.put(PROPERTY_TASK_CLASS, Collections.singletonList(this.taskClassName));
        props.put(PROPERTY_TASK_ARG, Collections.unmodifiableList(this.taskArguments));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

