/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class GetSnapshotsRequest
extends MasterNodeRequest<GetSnapshotsRequest> {
    public static final String ALL_SNAPSHOTS = "_all";
    public static final String CURRENT_SNAPSHOT = "_current";
    public static final boolean DEFAULT_VERBOSE_MODE = true;
    public static final Version MULTIPLE_REPOSITORIES_SUPPORT_ADDED = Version.V_7_14_0;
    public static final Version PAGINATED_GET_SNAPSHOTS_VERSION = Version.V_7_14_0;
    public static final Version NUMERIC_PAGINATION_VERSION = Version.V_7_15_0;
    public static final int NO_LIMIT = -1;
    private int size = -1;
    private int offset = 0;
    @Nullable
    private After after;
    private SortBy sort = SortBy.START_TIME;
    private SortOrder order = SortOrder.ASC;
    private String[] repositories;
    private String[] snapshots = Strings.EMPTY_ARRAY;
    private boolean ignoreUnavailable;
    private boolean verbose = true;

    public GetSnapshotsRequest() {
    }

    public GetSnapshotsRequest(String repository, String[] snapshots) {
        this.repositories = new String[]{repository};
        this.snapshots = snapshots;
    }

    public GetSnapshotsRequest(String[] repositories, String[] snapshots) {
        this.repositories = repositories;
        this.snapshots = snapshots;
    }

    public GetSnapshotsRequest(String ... repositories) {
        this.repositories = repositories;
    }

    public GetSnapshotsRequest(StreamInput in) throws IOException {
        super(in);
        this.repositories = in.getVersion().onOrAfter(MULTIPLE_REPOSITORIES_SUPPORT_ADDED) ? in.readStringArray() : new String[]{in.readString()};
        this.snapshots = in.readStringArray();
        this.ignoreUnavailable = in.readBoolean();
        this.verbose = in.readBoolean();
        if (in.getVersion().onOrAfter(PAGINATED_GET_SNAPSHOTS_VERSION)) {
            this.after = in.readOptionalWriteable(After::new);
            this.sort = in.readEnum(SortBy.class);
            this.size = in.readVInt();
            this.order = SortOrder.readFromStream(in);
            if (in.getVersion().onOrAfter(NUMERIC_PAGINATION_VERSION)) {
                this.offset = in.readVInt();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(MULTIPLE_REPOSITORIES_SUPPORT_ADDED)) {
            out.writeStringArray(this.repositories);
        } else {
            if (this.repositories.length != 1) {
                throw new IllegalArgumentException("Requesting snapshots from multiple repositories is not supported in versions prior to " + MULTIPLE_REPOSITORIES_SUPPORT_ADDED.toString());
            }
            out.writeString(this.repositories[0]);
        }
        out.writeStringArray(this.snapshots);
        out.writeBoolean(this.ignoreUnavailable);
        out.writeBoolean(this.verbose);
        if (out.getVersion().onOrAfter(PAGINATED_GET_SNAPSHOTS_VERSION)) {
            out.writeOptionalWriteable(this.after);
            out.writeEnum(this.sort);
            out.writeVInt(this.size);
            this.order.writeTo(out);
            if (out.getVersion().onOrAfter(NUMERIC_PAGINATION_VERSION)) {
                out.writeVInt(this.offset);
            } else if (this.offset != 0) {
                throw new IllegalArgumentException("can't use numeric offset in get snapshots request with node version [" + out.getVersion() + "]");
            }
        } else if (this.sort != SortBy.START_TIME || this.size != -1 || this.after != null || this.order != SortOrder.ASC) {
            throw new IllegalArgumentException("can't use paginated get snapshots request with node version [" + out.getVersion() + "]");
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repositories == null || this.repositories.length == 0) {
            validationException = ValidateActions.addValidationError("repositories are missing", validationException);
        }
        if (this.size == 0 || this.size < -1) {
            validationException = ValidateActions.addValidationError("size must be -1 or greater than 0", validationException);
        }
        if (!this.verbose) {
            if (this.sort != SortBy.START_TIME) {
                validationException = ValidateActions.addValidationError("can't use non-default sort with verbose=false", validationException);
            }
            if (this.size > 0) {
                validationException = ValidateActions.addValidationError("can't use size limit with verbose=false", validationException);
            }
            if (this.offset > 0) {
                validationException = ValidateActions.addValidationError("can't use offset with verbose=false", validationException);
            }
            if (this.after != null) {
                validationException = ValidateActions.addValidationError("can't use after with verbose=false", validationException);
            }
            if (this.order != SortOrder.ASC) {
                validationException = ValidateActions.addValidationError("can't use non-default sort order with verbose=false", validationException);
            }
        } else if (this.after != null && this.offset > 0) {
            validationException = ValidateActions.addValidationError("can't use after and offset simultaneously", validationException);
        }
        return validationException;
    }

    public GetSnapshotsRequest repositories(String ... repositories) {
        this.repositories = repositories;
        return this;
    }

    public String[] repositories() {
        return this.repositories;
    }

    public boolean isSingleRepositoryRequest() {
        return this.repositories.length == 1 && this.repositories[0] != null && !ALL_SNAPSHOTS.equals(this.repositories[0]) && !Regex.isSimpleMatchPattern(this.repositories[0]);
    }

    public GetSnapshotsRequest repository(String repository) {
        return this.repositories(repository);
    }

    public String repository() {
        if (this.repositories == null || this.repositories.length == 0) {
            return null;
        }
        if (this.repositories.length != 1) {
            throw new IllegalStateException("more than a single repository set for request");
        }
        return this.repositories[0];
    }

    public String[] snapshots() {
        return this.snapshots;
    }

    public GetSnapshotsRequest snapshots(String[] snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    public GetSnapshotsRequest ignoreUnavailable(boolean ignoreUnavailable) {
        this.ignoreUnavailable = ignoreUnavailable;
        return this;
    }

    public boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public GetSnapshotsRequest verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public After after() {
        return this.after;
    }

    public SortBy sort() {
        return this.sort;
    }

    public GetSnapshotsRequest after(@Nullable After after) {
        this.after = after;
        return this;
    }

    public GetSnapshotsRequest sort(SortBy sort) {
        this.sort = sort;
        return this;
    }

    public GetSnapshotsRequest size(int size) {
        this.size = size;
        return this;
    }

    public int size() {
        return this.size;
    }

    public int offset() {
        return this.offset;
    }

    public GetSnapshotsRequest offset(int offset) {
        this.offset = offset;
        return this;
    }

    public SortOrder order() {
        return this.order;
    }

    public GetSnapshotsRequest order(SortOrder order) {
        this.order = order;
        return this;
    }

    public boolean verbose() {
        return this.verbose;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    public static enum SortBy {
        START_TIME("start_time"),
        NAME("name"),
        DURATION("duration"),
        INDICES("index_count");

        private final String param;

        private SortBy(String param) {
            this.param = param;
        }

        public String toString() {
            return this.param;
        }

        public static SortBy of(String value) {
            switch (value) {
                case "start_time": {
                    return START_TIME;
                }
                case "name": {
                    return NAME;
                }
                case "duration": {
                    return DURATION;
                }
                case "index_count": {
                    return INDICES;
                }
            }
            throw new IllegalArgumentException("unknown sort order [" + value + "]");
        }
    }

    public static final class After
    implements Writeable {
        private final String value;
        private final String repoName;
        private final String snapshotName;

        After(StreamInput in) throws IOException {
            this(in.readString(), in.readString(), in.readString());
        }

        public static After fromQueryParam(String param) {
            String[] parts = new String(Base64.getUrlDecoder().decode(param), StandardCharsets.UTF_8).split(",");
            if (parts.length != 3) {
                throw new IllegalArgumentException("invalid ?after parameter [" + param + "]");
            }
            return new After(parts[0], parts[1], parts[2]);
        }

        @Nullable
        public static After from(@Nullable SnapshotInfo snapshotInfo, SortBy sortBy) {
            String afterValue;
            if (snapshotInfo == null) {
                return null;
            }
            switch (sortBy) {
                case START_TIME: {
                    afterValue = String.valueOf(snapshotInfo.startTime());
                    break;
                }
                case NAME: {
                    afterValue = snapshotInfo.snapshotId().getName();
                    break;
                }
                case DURATION: {
                    afterValue = String.valueOf(snapshotInfo.endTime() - snapshotInfo.startTime());
                    break;
                }
                case INDICES: {
                    afterValue = String.valueOf(snapshotInfo.indices().size());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown sort column [" + (Object)((Object)sortBy) + "]"));
                }
            }
            return new After(afterValue, snapshotInfo.repository(), snapshotInfo.snapshotId().getName());
        }

        public After(String value, String repoName, String snapshotName) {
            this.value = value;
            this.repoName = repoName;
            this.snapshotName = snapshotName;
        }

        public String value() {
            return this.value;
        }

        public String snapshotName() {
            return this.snapshotName;
        }

        public String repoName() {
            return this.repoName;
        }

        public String asQueryParam() {
            return Base64.getUrlEncoder().encodeToString((this.value + "," + this.repoName + "," + this.snapshotName).getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.value);
            out.writeString(this.repoName);
            out.writeString(this.snapshotName);
        }
    }
}

