/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;
import org.elasticsearch.Assertions;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.core.Releasable;

public class DeflateCompressor
implements Compressor {
    private static final byte[] HEADER = new byte[]{68, 70, 76, 0};
    private static final int LEVEL = 3;
    private static final int BUFFER_SIZE = 4096;
    private static final ThreadLocal<ReleasableReference<Inflater>> inflaterForStreamRef = ThreadLocal.withInitial(() -> {
        Inflater inflater = new Inflater(true);
        return new ReleasableReference<Inflater>(inflater, inflater::reset);
    });
    private static final ThreadLocal<ReleasableReference<Deflater>> deflaterForStreamRef = ThreadLocal.withInitial(() -> {
        Deflater deflater = new Deflater(3, true);
        return new ReleasableReference<Deflater>(deflater, deflater::reset);
    });
    private static final ThreadLocal<BytesStreamOutput> baos = ThreadLocal.withInitial(BytesStreamOutput::new);
    private static final ThreadLocal<Inflater> inflaterRef = ThreadLocal.withInitial(() -> new Inflater(true));
    private static final ThreadLocal<Deflater> deflaterRef = ThreadLocal.withInitial(() -> new Deflater(3, true));

    @Override
    public boolean isCompressed(BytesReference bytes) {
        if (bytes.length() < HEADER.length) {
            return false;
        }
        for (int i = 0; i < HEADER.length; ++i) {
            if (bytes.get(i) == HEADER[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int headerLength() {
        return HEADER.length;
    }

    @Override
    public InputStream threadLocalInputStream(InputStream in) throws IOException {
        return DeflateCompressor.inputStream(in, true);
    }

    public static InputStream inputStream(InputStream in, boolean threadLocal) throws IOException {
        Releasable releasable;
        Inflater inflater;
        int len;
        int read;
        byte[] headerBytes = new byte[HEADER.length];
        for (len = 0; len < headerBytes.length && (read = in.read(headerBytes, len, headerBytes.length - len)) != -1; len += read) {
        }
        if (len != HEADER.length || !Arrays.equals(headerBytes, HEADER)) {
            throw new IllegalArgumentException("Input stream is not compressed with DEFLATE!");
        }
        if (threadLocal) {
            ReleasableReference<Inflater> current = inflaterForStreamRef.get();
            if (current.inUse) {
                inflater = new Inflater(true);
                releasable = inflater::end;
            } else {
                inflater = current.get();
                releasable = current;
            }
        } else {
            inflater = new Inflater(true);
            releasable = inflater::end;
        }
        return new BufferedInputStream(new InflaterInputStream(in, inflater, 4096){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    releasable.close();
                }
            }
        }, 4096);
    }

    @Override
    public OutputStream threadLocalOutputStream(OutputStream out) throws IOException {
        Releasable releasable;
        Deflater deflater;
        out.write(HEADER);
        ReleasableReference<Deflater> current = deflaterForStreamRef.get();
        if (current.inUse) {
            deflater = new Deflater(3, true);
            releasable = deflater::end;
        } else {
            deflater = current.get();
            releasable = current;
        }
        boolean syncFlush = true;
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(out, deflater, 4096, true);
        return new BufferedOutputStream(deflaterOutputStream, 4096){
            private boolean closed;
            {
                super(arg0, arg1);
                this.closed = false;
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    super.close();
                }
                finally {
                    releasable.close();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesReference uncompress(BytesReference bytesReference) throws IOException {
        BytesStreamOutput buffer = baos.get();
        Inflater inflater = inflaterRef.get();
        try (InflaterOutputStream ios = new InflaterOutputStream(buffer, inflater);){
            bytesReference.slice(HEADER.length, bytesReference.length() - HEADER.length).writeTo(ios);
        }
        finally {
            inflater.reset();
        }
        BytesReference res = buffer.copyBytes();
        buffer.reset();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesReference compress(BytesReference bytesReference) throws IOException {
        BytesStreamOutput buffer = baos.get();
        buffer.write(HEADER);
        Deflater deflater = deflaterRef.get();
        try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)buffer, deflater, true);){
            bytesReference.writeTo(dos);
        }
        finally {
            deflater.reset();
        }
        BytesReference res = buffer.copyBytes();
        buffer.reset();
        return res;
    }

    private static final class ReleasableReference<T>
    implements Releasable {
        protected final T resource;
        private final Releasable releasable;
        private Thread thread = null;
        boolean inUse;

        protected ReleasableReference(T resource, Releasable releasable) {
            this.resource = resource;
            this.releasable = releasable;
        }

        T get() {
            if (Assertions.ENABLED) {
                assert (this.thread == null);
                this.thread = Thread.currentThread();
            }
            assert (!this.inUse);
            this.inUse = true;
            return this.resource;
        }

        @Override
        public void close() {
            if (Assertions.ENABLED) {
                assert (this.thread == Thread.currentThread()) : "Opened on [" + this.thread.getName() + "] but closed on [" + Thread.currentThread().getName() + "]";
                this.thread = null;
            }
            assert (this.inUse);
            this.inUse = false;
            this.releasable.close();
        }
    }
}

