/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledHeapByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.elasticsearch.nio.Page;

public class PagedByteBuf
extends UnpooledHeapByteBuf {
    private final Runnable releasable;

    private PagedByteBuf(byte[] array, Runnable releasable) {
        super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, array, array.length);
        this.releasable = releasable;
    }

    static ByteBuf byteBufFromPages(Page[] pages) {
        int componentCount = pages.length;
        if (componentCount == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (componentCount == 1) {
            return PagedByteBuf.byteBufFromPage(pages[0]);
        }
        int maxComponents = Math.max(16, componentCount);
        ArrayList<ByteBuf> components = new ArrayList<ByteBuf>(componentCount);
        for (Page page : pages) {
            components.add(PagedByteBuf.byteBufFromPage(page));
        }
        return new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, false, maxComponents, components);
    }

    private static ByteBuf byteBufFromPage(Page page) {
        ByteBuffer buffer = page.byteBuffer();
        assert (!buffer.isDirect() && buffer.hasArray()) : "Must be a heap buffer with an array";
        int offset = buffer.arrayOffset() + buffer.position();
        PagedByteBuf newByteBuf = new PagedByteBuf(buffer.array(), page::close);
        return newByteBuf.slice(offset, buffer.remaining());
    }

    @Override
    protected void deallocate() {
        try {
            super.deallocate();
        }
        finally {
            this.releasable.run();
        }
    }
}

