/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.shingle.FixedShingleFilter;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.FieldMaskingSpanQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.Version;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class TextFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "text";
    private static final String FAST_PHRASE_SUFFIX = "._index_phrase";
    private static final String FAST_PREFIX_SUFFIX = "._index_prefix";
    private static final FielddataFrequencyFilter DEFAULT_FILTER = new FielddataFrequencyFilter(0.0, 2.147483647E9, 0);
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), c.getIndexAnalyzers()));
    private final Builder builder;
    private final FieldType fieldType;
    private final SubFieldInfo prefixFieldInfo;
    private final SubFieldInfo phraseFieldInfo;

    private static Builder builder(FieldMapper in) {
        return ((TextFieldMapper)in).builder;
    }

    private static PrefixConfig parsePrefixConfig(String propName, MappingParserContext parserContext, Object propNode) {
        if (propNode == null) {
            return null;
        }
        Map indexPrefix = (Map)propNode;
        int minChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("min_chars"), 2);
        int maxChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("max_chars"), 5);
        MappingParser.checkNoRemainingFields(propName, indexPrefix);
        return new PrefixConfig(minChars, maxChars);
    }

    private static FielddataFrequencyFilter parseFrequencyFilter(String name, MappingParserContext parserContext, Object node) {
        Map frequencyFilter = (Map)node;
        double minFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("min"), 0.0);
        double maxFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("max"), 2.147483647E9);
        int minSegmentSize = XContentMapValues.nodeIntegerValue(frequencyFilter.remove("min_segment_size"), 0);
        MappingParser.checkNoRemainingFields(name, frequencyFilter);
        return new FielddataFrequencyFilter(minFrequency, maxFrequency, minSegmentSize);
    }

    protected TextFieldMapper(String simpleName, FieldType fieldType, TextFieldType mappedFieldType, Map<String, NamedAnalyzer> indexAnalyzers, SubFieldInfo prefixFieldInfo, SubFieldInfo phraseFieldInfo, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, indexAnalyzers, multiFields, copyTo, false, null);
        assert (mappedFieldType.getTextSearchInfo().isTokenized());
        assert (!mappedFieldType.hasDocValues());
        if (fieldType.indexOptions() == IndexOptions.NONE && this.fieldType().fielddata()) {
            throw new IllegalArgumentException("Cannot enable fielddata on a [text] field that is not indexed: [" + this.name() + "]");
        }
        this.fieldType = fieldType;
        this.prefixFieldInfo = prefixFieldInfo;
        this.phraseFieldInfo = phraseFieldInfo;
        this.builder = builder;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.indexCreatedVersion, this.builder.analyzers.indexAnalyzers).init(this);
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field field = new Field(this.fieldType().name(), value, (IndexableFieldType)this.fieldType);
            context.doc().add(field);
            if (this.fieldType.omitNorms()) {
                context.addToFieldNames(this.fieldType().name());
            }
            if (this.prefixFieldInfo != null) {
                context.doc().add(new Field(this.prefixFieldInfo.field, value, (IndexableFieldType)this.prefixFieldInfo.fieldType));
            }
            if (this.phraseFieldInfo != null) {
                context.doc().add(new Field(this.phraseFieldInfo.field, value, (IndexableFieldType)this.phraseFieldInfo.fieldType));
            }
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public TextFieldType fieldType() {
        return (TextFieldType)super.fieldType();
    }

    public static Query createPhraseQuery(TokenStream stream, String field, int slop, boolean enablePositionIncrements) throws IOException {
        MultiPhraseQuery.Builder mpqb = new MultiPhraseQuery.Builder();
        mpqb.setSlop(slop);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        ArrayList<Term> multiTerms = new ArrayList<Term>();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && multiTerms.size() > 0) {
                if (enablePositionIncrements) {
                    mpqb.add(multiTerms.toArray(new Term[0]), position);
                } else {
                    mpqb.add(multiTerms.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position += positionIncrement;
            multiTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        if (enablePositionIncrements) {
            mpqb.add(multiTerms.toArray(new Term[0]), position);
        } else {
            mpqb.add(multiTerms.toArray(new Term[0]));
        }
        return mpqb.build();
    }

    public static Query createPhrasePrefixQuery(TokenStream stream, String field, int slop, int maxExpansions, String prefixField, IntPredicate usePrefixField) throws IOException {
        MultiPhrasePrefixQuery builder = new MultiPhrasePrefixQuery(field);
        builder.setSlop(slop);
        builder.setMaxExpansions(maxExpansions);
        ArrayList<Term> currentTerms = new ArrayList<Term>();
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        int position = -1;
        while (stream.incrementToken()) {
            if (posIncrAtt.getPositionIncrement() != 0) {
                if (!currentTerms.isEmpty()) {
                    builder.add(currentTerms.toArray(new Term[0]), position);
                }
                position += posIncrAtt.getPositionIncrement();
                currentTerms.clear();
            }
            currentTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        builder.add(currentTerms.toArray(new Term[0]), position);
        if (prefixField == null) {
            return builder;
        }
        int lastPos = builder.getTerms().length - 1;
        Term[][] terms = builder.getTerms();
        int[] positions = builder.getPositions();
        for (Term term2 : terms[lastPos]) {
            String value = term2.text();
            if (usePrefixField.test(value.length())) continue;
            return builder;
        }
        if (terms.length == 1) {
            SynonymQuery.Builder sb = new SynonymQuery.Builder(prefixField);
            Arrays.stream(terms[0]).map(term -> new Term(prefixField, term.bytes())).forEach(sb::addTerm);
            return sb.build();
        }
        SpanNearQuery.Builder spanQuery = new SpanNearQuery.Builder(field, true);
        spanQuery.setSlop(slop);
        int previousPos = -1;
        for (int i = 0; i < terms.length; ++i) {
            SpanQuery[] queries;
            Term[] posTerms = terms[i];
            int posInc = positions[i] - previousPos;
            previousPos = positions[i];
            if (posInc > 1) {
                spanQuery.addGap(posInc - 1);
            }
            if (i == lastPos) {
                if (posTerms.length == 1) {
                    FieldMaskingSpanQuery fieldMask = new FieldMaskingSpanQuery(new SpanTermQuery(new Term(prefixField, posTerms[0].bytes())), field);
                    spanQuery.addClause(fieldMask);
                    continue;
                }
                queries = (SpanQuery[])Arrays.stream(posTerms).map(term -> new FieldMaskingSpanQuery(new SpanTermQuery(new Term(prefixField, term.bytes())), field)).toArray(SpanQuery[]::new);
                spanQuery.addClause(new SpanOrQuery(queries));
                continue;
            }
            if (posTerms.length == 1) {
                spanQuery.addClause(new SpanTermQuery(posTerms[0]));
                continue;
            }
            queries = (SpanTermQuery[])Arrays.stream(posTerms).map(SpanTermQuery::new).toArray(SpanTermQuery[]::new);
            spanQuery.addClause(new SpanOrQuery(queries));
        }
        return spanQuery.build();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        builder.field("type", this.contentType());
        this.builder.boost.toXContent(builder, includeDefaults);
        this.builder.index.toXContent(builder, includeDefaults);
        this.builder.store.toXContent(builder, includeDefaults);
        this.multiFields.toXContent(builder, params);
        this.copyTo.toXContent(builder, params);
        this.builder.meta.toXContent(builder, includeDefaults);
        this.builder.indexOptions.toXContent(builder, includeDefaults);
        this.builder.termVectors.toXContent(builder, includeDefaults);
        this.builder.norms.toXContent(builder, includeDefaults);
        this.builder.analyzers.indexAnalyzer.toXContent(builder, includeDefaults);
        this.builder.analyzers.searchAnalyzer.toXContent(builder, includeDefaults);
        this.builder.analyzers.searchQuoteAnalyzer.toXContent(builder, includeDefaults);
        this.builder.similarity.toXContent(builder, includeDefaults);
        this.builder.eagerGlobalOrdinals.toXContent(builder, includeDefaults);
        this.builder.analyzers.positionIncrementGap.toXContent(builder, includeDefaults);
        this.builder.fieldData.toXContent(builder, includeDefaults);
        this.builder.freqFilter.toXContent(builder, includeDefaults);
        this.builder.indexPrefixes.toXContent(builder, includeDefaults);
        this.builder.indexPhrases.toXContent(builder, includeDefaults);
    }

    private static final class FielddataFrequencyFilter
    implements ToXContent {
        final double minFreq;
        final double maxFreq;
        final int minSegmentSize;

        private FielddataFrequencyFilter(double minFreq, double maxFreq, int minSegmentSize) {
            this.minFreq = minFreq;
            this.maxFreq = maxFreq;
            this.minSegmentSize = minSegmentSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FielddataFrequencyFilter that = (FielddataFrequencyFilter)o;
            return Double.compare(that.minFreq, this.minFreq) == 0 && Double.compare(that.maxFreq, this.maxFreq) == 0 && this.minSegmentSize == that.minSegmentSize;
        }

        public int hashCode() {
            return Objects.hash(this.minFreq, this.maxFreq, this.minSegmentSize);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("min", this.minFreq);
            builder.field("max", this.maxFreq);
            builder.field("min_segment_size", this.minSegmentSize);
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "{ min=" + this.minFreq + ", max=" + this.maxFreq + ", min_segment_size=" + this.minSegmentSize + " }";
        }
    }

    private static final class PrefixConfig
    implements ToXContent {
        final int minChars;
        final int maxChars;

        private PrefixConfig(int minChars, int maxChars) {
            this.minChars = minChars;
            this.maxChars = maxChars;
            if (minChars > maxChars) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be less than max_chars [" + maxChars + "]");
            }
            if (minChars < 1) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be greater than zero");
            }
            if (maxChars >= 20) {
                throw new IllegalArgumentException("max_chars [" + maxChars + "] must be less than 20");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrefixConfig that = (PrefixConfig)o;
            return this.minChars == that.minChars && this.maxChars == that.maxChars;
        }

        public int hashCode() {
            return Objects.hash(this.minChars, this.maxChars);
        }

        public String toString() {
            return "{ min_chars=" + this.minChars + ", max_chars=" + this.maxChars + " }";
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("min_chars", this.minChars);
            builder.field("max_chars", this.maxChars);
            builder.endObject();
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final Version indexCreatedVersion;
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> TextFieldMapper.builder((FieldMapper)m).index.getValue(), true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> TextFieldMapper.builder((FieldMapper)m).store.getValue(), false);
        final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> TextFieldMapper.builder((FieldMapper)m).similarity.getValue());
        final FieldMapper.Parameter<String> indexOptions = TextParams.indexOptions(m -> TextFieldMapper.builder((FieldMapper)m).indexOptions.getValue());
        final FieldMapper.Parameter<Boolean> norms = TextParams.norms(true, m -> TextFieldMapper.builder((FieldMapper)m).norms.getValue());
        final FieldMapper.Parameter<String> termVectors = TextParams.termVectors(m -> TextFieldMapper.builder((FieldMapper)m).termVectors.getValue());
        final FieldMapper.Parameter<Boolean> fieldData = FieldMapper.Parameter.boolParam("fielddata", true, m -> TextFieldMapper.builder((FieldMapper)m).fieldData.getValue(), false);
        final FieldMapper.Parameter<FielddataFrequencyFilter> freqFilter = new FieldMapper.Parameter<FielddataFrequencyFilter>("fielddata_frequency_filter", true, () -> TextFieldMapper.access$800(), (x$0, x$1, x$2) -> TextFieldMapper.access$700(x$0, x$1, x$2), m -> TextFieldMapper.builder((FieldMapper)m).freqFilter.getValue());
        final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> TextFieldMapper.builder((FieldMapper)m).eagerGlobalOrdinals.getValue(), false);
        final FieldMapper.Parameter<Boolean> indexPhrases = FieldMapper.Parameter.boolParam("index_phrases", false, m -> TextFieldMapper.builder((FieldMapper)m).indexPhrases.getValue(), false);
        final FieldMapper.Parameter<PrefixConfig> indexPrefixes = new FieldMapper.Parameter<PrefixConfig>("index_prefixes", false, () -> null, (x$0, x$1, x$2) -> TextFieldMapper.access$600(x$0, x$1, x$2), m -> TextFieldMapper.builder((FieldMapper)m).indexPrefixes.getValue()).acceptsNull();
        private final FieldMapper.Parameter<Float> boost = FieldMapper.Parameter.boostParam();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final TextParams.Analyzers analyzers;

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            this(name, Version.CURRENT, indexAnalyzers);
        }

        public Builder(String name, Version indexCreatedVersion, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
            this.analyzers = new TextParams.Analyzers(indexAnalyzers, m -> TextFieldMapper.builder((FieldMapper)m).analyzers);
        }

        public Builder index(boolean index) {
            this.index.setValue(index);
            return this;
        }

        public Builder store(boolean store) {
            this.store.setValue(store);
            return this;
        }

        public Builder fielddata(boolean fielddata) {
            this.fieldData.setValue(fielddata);
            return this;
        }

        public Builder fielddataFrequencyFilter(double min, double max, int segs) {
            this.freqFilter.setValue(new FielddataFrequencyFilter(min, max, segs));
            return this;
        }

        public Builder addMultiField(FieldMapper.Builder builder) {
            this.multiFieldsBuilder.add(builder);
            return this;
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.store, this.indexOptions, this.norms, this.termVectors, this.analyzers.indexAnalyzer, this.analyzers.searchAnalyzer, this.analyzers.searchQuoteAnalyzer, this.similarity, this.analyzers.positionIncrementGap, this.fieldData, this.freqFilter, this.eagerGlobalOrdinals, this.indexPhrases, this.indexPrefixes, this.boost, this.meta);
        }

        private TextFieldType buildFieldType(FieldType fieldType, ContentPath contentPath) {
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            NamedAnalyzer searchQuoteAnalyzer = this.analyzers.getSearchQuoteAnalyzer();
            if (this.analyzers.positionIncrementGap.isConfigured() && fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
            }
            TextSearchInfo tsi = new TextSearchInfo(fieldType, this.similarity.getValue(), searchAnalyzer, searchQuoteAnalyzer);
            TextFieldType ft = new TextFieldType(this.buildFullName(contentPath), this.index.getValue(), this.store.getValue(), tsi, this.meta.getValue());
            ft.eagerGlobalOrdinals = this.eagerGlobalOrdinals.getValue();
            ft.setBoost(this.boost.getValue().floatValue());
            if (this.fieldData.getValue().booleanValue()) {
                ft.setFielddata(true, this.freqFilter.getValue());
            }
            return ft;
        }

        private SubFieldInfo buildPrefixInfo(ContentPath contentPath, FieldType fieldType, TextFieldType tft) {
            if (this.indexPrefixes.get() == null) {
                return null;
            }
            if (!this.index.getValue().booleanValue()) {
                throw new IllegalArgumentException("Cannot set index_prefixes on unindexed field [" + this.name() + "]");
            }
            String fullName = this.indexCreatedVersion.before(Version.V_7_2_1) ? this.name() : this.buildFullName(contentPath);
            FieldType pft = new FieldType(fieldType);
            pft.setOmitNorms(true);
            if (fieldType.indexOptions() == IndexOptions.DOCS_AND_FREQS) {
                pft.setIndexOptions(IndexOptions.DOCS);
            } else {
                pft.setIndexOptions(fieldType.indexOptions());
            }
            if (fieldType.storeTermVectorOffsets()) {
                pft.setStoreTermVectorOffsets(true);
            }
            tft.setIndexPrefixes(this.indexPrefixes.get().minChars, this.indexPrefixes.get().maxChars);
            return new SubFieldInfo(fullName + TextFieldMapper.FAST_PREFIX_SUFFIX, pft, new PrefixWrappedAnalyzer(this.analyzers.getIndexAnalyzer().analyzer(), this.analyzers.positionIncrementGap.get(), this.indexPrefixes.get().minChars, this.indexPrefixes.get().maxChars));
        }

        private SubFieldInfo buildPhraseInfo(FieldType fieldType, TextFieldType parent) {
            if (!this.indexPhrases.get().booleanValue()) {
                return null;
            }
            if (!this.index.get().booleanValue()) {
                throw new IllegalArgumentException("Cannot set index_phrases on unindexed field [" + this.name() + "]");
            }
            if (fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                throw new IllegalArgumentException("Cannot set index_phrases on field [" + this.name() + "] if positions are not enabled");
            }
            FieldType phraseFieldType = new FieldType(fieldType);
            parent.setIndexPhrases();
            PhraseWrappedAnalyzer a = new PhraseWrappedAnalyzer(this.analyzers.getIndexAnalyzer().analyzer(), this.analyzers.positionIncrementGap.get());
            return new SubFieldInfo(parent.name() + TextFieldMapper.FAST_PHRASE_SUFFIX, phraseFieldType, a);
        }

        public Map<String, NamedAnalyzer> indexAnalyzers(String name, SubFieldInfo phraseFieldInfo, SubFieldInfo prefixFieldInfo) {
            HashMap<String, NamedAnalyzer> analyzers = new HashMap<String, NamedAnalyzer>();
            NamedAnalyzer main = this.analyzers.getIndexAnalyzer();
            analyzers.put(name, main);
            if (phraseFieldInfo != null) {
                analyzers.put(phraseFieldInfo.field, new NamedAnalyzer(main.name() + "_phrase", AnalyzerScope.INDEX, phraseFieldInfo.analyzer));
            }
            if (prefixFieldInfo != null) {
                analyzers.put(prefixFieldInfo.field, new NamedAnalyzer(main.name() + "_prefix", AnalyzerScope.INDEX, prefixFieldInfo.analyzer));
            }
            return analyzers;
        }

        @Override
        public TextFieldMapper build(ContentPath contentPath) {
            FieldType fieldType = TextParams.buildFieldType(this.index, this.store, this.indexOptions, this.norms, this.termVectors);
            TextFieldType tft = this.buildFieldType(fieldType, contentPath);
            SubFieldInfo phraseFieldInfo = this.buildPhraseInfo(fieldType, tft);
            SubFieldInfo prefixFieldInfo = this.buildPrefixInfo(contentPath, fieldType, tft);
            FieldMapper.MultiFields multiFields = this.multiFieldsBuilder.build(this, contentPath);
            for (Mapper mapper : multiFields) {
                if (!mapper.name().endsWith(TextFieldMapper.FAST_PHRASE_SUFFIX) && !mapper.name().endsWith(TextFieldMapper.FAST_PREFIX_SUFFIX)) continue;
                throw new MapperParsingException("Cannot use reserved field name [" + mapper.name() + "]");
            }
            return new TextFieldMapper(this.name, fieldType, tft, this.indexAnalyzers(tft.name(), phraseFieldInfo, prefixFieldInfo), prefixFieldInfo, phraseFieldInfo, multiFields, this.copyTo.build(), this);
        }
    }

    public static class Defaults {
        public static final double FIELDDATA_MIN_FREQUENCY = 0.0;
        public static final double FIELDDATA_MAX_FREQUENCY = 2.147483647E9;
        public static final int FIELDDATA_MIN_SEGMENT_SIZE = 0;
        public static final int INDEX_PREFIX_MIN_CHARS = 2;
        public static final int INDEX_PREFIX_MAX_CHARS = 5;
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final int POSITION_INCREMENT_GAP = 100;

        static {
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setOmitNorms(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.freeze();
        }
    }

    public static class TextFieldType
    extends StringFieldType {
        private boolean fielddata = false;
        private FielddataFrequencyFilter filter;
        private PrefixFieldType prefixFieldType;
        private boolean indexPhrases = false;
        private boolean eagerGlobalOrdinals = false;

        public TextFieldType(String name, boolean indexed, boolean stored, TextSearchInfo tsi, Map<String, String> meta) {
            super(name, indexed, stored, false, tsi, meta);
        }

        public TextFieldType(String name, boolean indexed, boolean stored, Map<String, String> meta) {
            super(name, indexed, stored, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), meta);
        }

        public TextFieldType(String name) {
            this(name, true, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), Collections.emptyMap());
        }

        public boolean fielddata() {
            return this.fielddata;
        }

        @Override
        public boolean eagerGlobalOrdinals() {
            return this.eagerGlobalOrdinals;
        }

        public void setFielddata(boolean fielddata, FielddataFrequencyFilter filter) {
            this.fielddata = fielddata;
            this.filter = filter;
        }

        public void setFielddata(boolean fielddata) {
            this.setFielddata(fielddata, DEFAULT_FILTER);
        }

        double fielddataMinFrequency() {
            return this.filter.minFreq;
        }

        double fielddataMaxFrequency() {
            return this.filter.maxFreq;
        }

        int fielddataMinSegmentSize() {
            return this.filter.minSegmentSize;
        }

        void setIndexPrefixes(int minChars, int maxChars) {
            this.prefixFieldType = new PrefixFieldType(this, minChars, maxChars);
        }

        void setIndexPhrases() {
            this.indexPhrases = true;
        }

        public PrefixFieldType getPrefixFieldType() {
            return this.prefixFieldType;
        }

        @Override
        public String typeName() {
            return TextFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString(this.name(), context, format);
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            if (this.prefixFieldType == null || !this.prefixFieldType.accept(value.length())) {
                return super.prefixQuery(value, method, caseInsensitive, context);
            }
            Query tq = this.prefixFieldType.prefixQuery(value, method, caseInsensitive, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(tq);
            }
            return tq;
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, SearchExecutionContext context) {
            this.failIfNotIndexed();
            if (this.prefixFieldType != null && value.length() >= this.prefixFieldType.minChars && value.length() <= this.prefixFieldType.maxChars && this.prefixFieldType.getTextSearchInfo().hasPositions()) {
                return new FieldMaskingSpanQuery(new SpanTermQuery(new Term(this.prefixFieldType.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper<PrefixQuery> spanMulti = new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }

        @Override
        public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            return Intervals.term((BytesRef)term);
        }

        @Override
        public IntervalsSource prefixIntervals(BytesRef term, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            if (this.prefixFieldType != null) {
                return this.prefixFieldType.intervals(term);
            }
            return Intervals.prefix((BytesRef)term);
        }

        @Override
        public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            FuzzyQuery fq = new FuzzyQuery(new Term(this.name(), term), maxDistance, prefixLength, 128, transpositions);
            return Intervals.multiterm((CompiledAutomaton)fq.getAutomata(), (String)term);
        }

        @Override
        public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            return Intervals.wildcard((BytesRef)pattern);
        }

        private void checkForPositions() {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalStateException("field:[" + this.name() + "] was indexed without position data; cannot run PhraseQuery");
            }
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements, SearchExecutionContext context) throws IOException {
            String field = this.name();
            this.checkForPositions();
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(stream) && !stream.hasAttribute(BytesTermAttribute.class)) {
                stream = new FixedShingleFilter(stream, 2);
                field = field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
            int position = -1;
            stream.reset();
            while (stream.incrementToken()) {
                if (termAtt.getBytesRef() == null) {
                    throw new IllegalStateException("Null term while building phrase query");
                }
                position = enablePosIncrements ? (position += posIncrAtt.getPositionIncrement()) : ++position;
                builder.add(new Term(field, termAtt.getBytesRef()), position);
            }
            return builder.build();
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) throws IOException {
            String field = this.name();
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(stream)) {
                stream = new FixedShingleFilter(stream, 2);
                field = field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            return TextFieldMapper.createPhraseQuery(stream, field, slop, enablePositionIncrements);
        }

        private int countTokens(TokenStream ts) throws IOException {
            ts.reset();
            int count = 0;
            while (ts.incrementToken()) {
                ++count;
            }
            ts.end();
            return count;
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext context) throws IOException {
            if (this.countTokens(stream) > 1) {
                this.checkForPositions();
            }
            return this.analyzePhrasePrefix(stream, slop, maxExpansions);
        }

        private Query analyzePhrasePrefix(TokenStream stream, int slop, int maxExpansions) throws IOException {
            String prefixField = this.prefixFieldType == null || slop > 0 ? null : this.prefixFieldType.name();
            IntPredicate usePrefix = len -> len >= this.prefixFieldType.minChars && len <= this.prefixFieldType.maxChars;
            return TextFieldMapper.createPhrasePrefixQuery(stream, this.name(), slop, maxExpansions, prefixField, usePrefix);
        }

        public static boolean hasGaps(TokenStream stream) throws IOException {
            assert (stream instanceof CachingTokenFilter);
            PositionIncrementAttribute posIncAtt = stream.getAttribute(PositionIncrementAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                if (posIncAtt.getPositionIncrement() <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            if (!this.fielddata) {
                throw new IllegalArgumentException("Text fields are not optimised for operations that require per-document field data like aggregations and sorting, so these operations are disabled by default. Please use a keyword field instead. Alternatively, set fielddata=true on [" + this.name() + "] in order to load field data by uninverting the inverted index. Note that this can use significant memory.");
            }
            return new PagedBytesIndexFieldData.Builder(this.name(), this.filter.minFreq, this.filter.maxFreq, this.filter.minSegmentSize, CoreValuesSourceType.KEYWORD);
        }
    }

    private static final class SubFieldInfo {
        private final Analyzer analyzer;
        private final FieldType fieldType;
        private final String field;

        SubFieldInfo(String field, FieldType fieldType, Analyzer analyzer) {
            this.fieldType = fieldType;
            this.analyzer = analyzer;
            this.field = field;
        }
    }

    private static final class PrefixFieldType
    extends StringFieldType {
        final int minChars;
        final int maxChars;
        final TextFieldType parentField;

        PrefixFieldType(TextFieldType parentField, int minChars, int maxChars) {
            super(parentField.name() + TextFieldMapper.FAST_PREFIX_SUFFIX, true, false, false, parentField.getTextSearchInfo(), Collections.emptyMap());
            this.minChars = minChars;
            this.maxChars = maxChars;
            this.parentField = parentField;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException();
        }

        boolean accept(int length) {
            return length >= this.minChars - 1 && length <= this.maxChars;
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            if (value.length() >= this.minChars) {
                if (caseInsensitive) {
                    return super.termQueryCaseInsensitive(value, context);
                }
                return super.termQuery(value, context);
            }
            ArrayList<Automaton> automata = new ArrayList<Automaton>();
            if (caseInsensitive) {
                automata.add(AutomatonQueries.toCaseInsensitiveString(value, Integer.MAX_VALUE));
            } else {
                automata.add(Automata.makeString(value));
            }
            for (int i = value.length(); i < this.minChars; ++i) {
                automata.add(Automata.makeAnyChar());
            }
            Automaton automaton = Operations.concatenate(automata);
            AutomatonQuery query = new AutomatonQuery(new Term(this.name(), value + "*"), automaton);
            query.setRewriteMethod(method);
            return new BooleanQuery.Builder().add(query, BooleanClause.Occur.SHOULD).add(new TermQuery(new Term(this.parentField.name(), value)), BooleanClause.Occur.SHOULD).build();
        }

        public IntervalsSource intervals(BytesRef term) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over a field [" + this.name() + "] without indexed positions");
            }
            if (term.length > this.maxChars) {
                return Intervals.prefix((BytesRef)term);
            }
            if (term.length >= this.minChars) {
                return Intervals.fixField((String)this.name(), (IntervalsSource)Intervals.term((BytesRef)term));
            }
            StringBuilder sb = new StringBuilder(term.utf8ToString());
            for (int i = term.length; i < this.minChars; ++i) {
                sb.append("?");
            }
            String wildcardTerm = sb.toString();
            return Intervals.or((IntervalsSource[])new IntervalsSource[]{Intervals.fixField((String)this.name(), (IntervalsSource)Intervals.wildcard((BytesRef)new BytesRef(wildcardTerm))), Intervals.term((BytesRef)term)});
        }

        @Override
        public String typeName() {
            return "prefix";
        }

        public String toString() {
            return super.toString() + ",prefixChars=" + this.minChars + ":" + this.maxChars;
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new UnsupportedOperationException();
        }
    }

    private static class PrefixWrappedAnalyzer
    extends AnalyzerWrapper {
        private final int minChars;
        private final int maxChars;
        private final int posIncGap;
        private final Analyzer delegate;

        PrefixWrappedAnalyzer(Analyzer delegate, int posIncGap, int minChars, int maxChars) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
            this.posIncGap = posIncGap;
            this.minChars = minChars;
            this.maxChars = maxChars;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        @Override
        public int getPositionIncrementGap(String fieldName) {
            return this.posIncGap;
        }

        @Override
        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            EdgeNGramTokenFilter filter = new EdgeNGramTokenFilter(components.getTokenStream(), this.minChars, this.maxChars, false);
            return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)filter);
        }
    }

    private static class PhraseWrappedAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;
        private final int posIncGap;

        PhraseWrappedAnalyzer(Analyzer delegate, int posIncGap) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
            this.posIncGap = posIncGap;
        }

        @Override
        public int getPositionIncrementGap(String fieldName) {
            return this.posIncGap;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        @Override
        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)new FixedShingleFilter(components.getTokenStream(), 2));
        }
    }
}

