/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.List;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;

public final class GetSnapshotInfoContext
implements ActionListener<SnapshotInfo> {
    private static final Logger logger = LogManager.getLogger(GetSnapshotInfoContext.class);
    private final java.util.List<SnapshotId> snapshotIds;
    private final boolean abortOnFailure;
    private final BooleanSupplier isCancelled;
    private final ActionListener<Void> doneListener;
    private final BiConsumer<GetSnapshotInfoContext, SnapshotInfo> consumer;
    private final CountDown counter;

    public GetSnapshotInfoContext(Collection<SnapshotId> snapshotIds, boolean abortOnFailure, BooleanSupplier isCancelled, BiConsumer<GetSnapshotInfoContext, SnapshotInfo> consumer, ActionListener<Void> listener) {
        if (snapshotIds.isEmpty()) {
            throw new IllegalArgumentException("no snapshot ids to fetch given");
        }
        this.snapshotIds = List.copyOf(snapshotIds);
        this.counter = new CountDown(snapshotIds.size());
        this.abortOnFailure = abortOnFailure;
        this.isCancelled = isCancelled;
        this.consumer = consumer;
        this.doneListener = listener;
    }

    public java.util.List<SnapshotId> snapshotIds() {
        return this.snapshotIds;
    }

    public boolean abortOnFailure() {
        return this.abortOnFailure;
    }

    public boolean isCancelled() {
        return this.isCancelled.getAsBoolean();
    }

    public boolean done() {
        return this.counter.isCountedDown();
    }

    @Override
    public void onResponse(SnapshotInfo snapshotInfo) {
        assert (Repository.assertSnapshotMetaThread());
        try {
            this.consumer.accept(this, snapshotInfo);
        }
        catch (Exception e) {
            assert (false) : e;
            this.onFailure(e);
            return;
        }
        if (this.counter.countDown()) {
            try {
                this.doneListener.onResponse(null);
            }
            catch (Exception e) {
                assert (false) : e;
                this.failDoneListener(e);
            }
        }
    }

    @Override
    public void onFailure(Exception e) {
        assert (Repository.assertSnapshotMetaThread());
        if (this.abortOnFailure || this.isCancelled()) {
            if (this.counter.fastForward()) {
                this.failDoneListener(e);
            }
        } else {
            logger.warn("failed to fetch snapshot info", (Throwable)e);
            if (this.counter.countDown()) {
                this.doneListener.onResponse(null);
            }
        }
    }

    private void failDoneListener(Exception failure) {
        try {
            this.doneListener.onFailure(failure);
        }
        catch (Exception ex) {
            assert (false) : ex;
            throw ex;
        }
    }
}

