/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.global;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.global.InternalGlobal;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class GlobalAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final Weight weight;

    public GlobalAggregator(String name, AggregatorFactories subFactories, AggregationContext context, Map<String, Object> metadata) throws IOException {
        super(name, subFactories, context, null, CardinalityUpperBound.ONE, metadata);
        this.weight = context.filterQuery(new MatchAllDocsQuery()).createWeight(context.searcher(), this.scoreMode(), 1.0f);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        BulkScorer scorer = this.weight.bulkScorer(ctx);
        if (scorer == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        scorer.score(new LeafCollector(){

            @Override
            public void collect(int doc) throws IOException {
                GlobalAggregator.this.collectBucket(sub, doc, 0L);
            }

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                sub.setScorer(scorer);
            }
        }, ctx.reader().getLiveDocs());
        return LeafBucketCollector.NO_OP_COLLECTOR;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        assert (owningBucketOrds.length == 1 && owningBucketOrds[0] == 0L) : "global aggregator can only be a top level aggregator";
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalGlobal(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        throw new UnsupportedOperationException("global aggregations cannot serve as sub-aggregations, hence should never be called on #buildEmptyAggregations");
    }
}

