/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.MaxScoreCollector;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalTopHits;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.sort.SortAndFormats;

class TopHitsAggregator
extends MetricsAggregator {
    private final SubSearchContext subSearchContext;
    private final LongObjectPagedHashMap<Collectors> topDocsCollectors;

    TopHitsAggregator(SubSearchContext subSearchContext, String name, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.topDocsCollectors = new LongObjectPagedHashMap(1L, context.bigArrays());
        this.subSearchContext = subSearchContext;
    }

    @Override
    public ScoreMode scoreMode() {
        SortAndFormats sort = this.subSearchContext.sort();
        if (sort != null) {
            return sort.sort.needsScores() || this.subSearchContext.trackScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        }
        return ScoreMode.COMPLETE;
    }

    @Override
    public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final LongObjectHashMap leafCollectors = new LongObjectHashMap(1);
        return new LeafBucketCollectorBase(sub, null){
            Scorable scorer;

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
                super.setScorer(scorer);
                for (ObjectCursor cursor : leafCollectors.values()) {
                    ((LeafCollector)cursor.value).setScorer(scorer);
                }
            }

            @Override
            public void collect(int docId, long bucket) throws IOException {
                LeafCollector leafCollector;
                int key;
                Collectors collectors = (Collectors)TopHitsAggregator.this.topDocsCollectors.get(bucket);
                if (collectors == null) {
                    SortAndFormats sort = TopHitsAggregator.this.subSearchContext.sort();
                    int topN = TopHitsAggregator.this.subSearchContext.from() + TopHitsAggregator.this.subSearchContext.size();
                    if (sort == null) {
                        for (RescoreContext rescoreContext : TopHitsAggregator.this.subSearchContext.rescore()) {
                            topN = Math.max(rescoreContext.getWindowSize(), topN);
                        }
                    }
                    topN = Math.min(topN, TopHitsAggregator.this.subSearchContext.searcher().getIndexReader().maxDoc());
                    collectors = sort == null ? new Collectors(TopScoreDocCollector.create(topN, Integer.MAX_VALUE), null) : new Collectors(TopFieldCollector.create(sort.sort, topN, Integer.MAX_VALUE), TopHitsAggregator.this.subSearchContext.trackScores() ? new MaxScoreCollector() : null);
                    TopHitsAggregator.this.topDocsCollectors.put(bucket, collectors);
                }
                if ((key = leafCollectors.indexOf(bucket)) < 0) {
                    leafCollector = collectors.collector.getLeafCollector(ctx);
                    if (this.scorer != null) {
                        leafCollector.setScorer(this.scorer);
                    }
                    leafCollectors.indexInsert(key, bucket, (Object)leafCollector);
                } else {
                    leafCollector = (LeafCollector)leafCollectors.indexGet(key);
                }
                leafCollector.collect(docId);
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        Collectors collectors = this.topDocsCollectors.get(owningBucketOrdinal);
        if (collectors == null) {
            return this.buildEmptyAggregation();
        }
        TopDocsCollector<?> topDocsCollector = collectors.topDocsCollector;
        TopDocs topDocs = topDocsCollector.topDocs();
        float maxScore = Float.NaN;
        if (this.subSearchContext.sort() == null) {
            for (RescoreContext ctx : this.subSearchContext.rescore()) {
                try {
                    topDocs = ctx.rescorer().rescore(topDocs, this.searcher(), ctx);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Rescore TopHits Failed", (Throwable)e, new Object[0]);
                }
            }
            if (topDocs.scoreDocs.length > 0) {
                maxScore = topDocs.scoreDocs[0].score;
            }
        } else if (this.subSearchContext.trackScores()) {
            TopFieldCollector.populateScores(topDocs.scoreDocs, this.subSearchContext.searcher(), this.subSearchContext.query());
            maxScore = collectors.maxScoreCollector.getMaxScore();
        }
        TopDocsAndMaxScore topDocsAndMaxScore = new TopDocsAndMaxScore(topDocs, maxScore);
        this.subSearchContext.queryResult().topDocs(topDocsAndMaxScore, this.subSearchContext.sort() == null ? null : this.subSearchContext.sort().formats);
        int[] docIdsToLoad = new int[topDocs.scoreDocs.length];
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            docIdsToLoad[i] = topDocs.scoreDocs[i].doc;
        }
        this.subSearchContext.docIdsToLoad(docIdsToLoad, docIdsToLoad.length);
        this.subSearchContext.fetchPhase().execute(this.subSearchContext);
        FetchSearchResult fetchResult = this.subSearchContext.fetchResult();
        SearchHit[] internalHits = fetchResult.fetchResult().hits().getHits();
        for (int i = 0; i < internalHits.length; ++i) {
            ScoreDoc scoreDoc = topDocs.scoreDocs[i];
            SearchHit searchHitFields = internalHits[i];
            searchHitFields.shard(this.subSearchContext.shardTarget());
            searchHitFields.score(scoreDoc.score);
            if (!(scoreDoc instanceof FieldDoc)) continue;
            FieldDoc fieldDoc = (FieldDoc)scoreDoc;
            searchHitFields.sortValues(fieldDoc.fields, this.subSearchContext.sort().formats);
        }
        return new InternalTopHits(this.name, this.subSearchContext.from(), this.subSearchContext.size(), topDocsAndMaxScore, fetchResult.hits(), this.metadata());
    }

    @Override
    public InternalTopHits buildEmptyAggregation() {
        TopDocs topDocs = this.subSearchContext.sort() != null ? new TopFieldDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), new FieldDoc[0], this.subSearchContext.sort().sort.getSort()) : Lucene.EMPTY_TOP_DOCS;
        return new InternalTopHits(this.name, this.subSearchContext.from(), this.subSearchContext.size(), new TopDocsAndMaxScore(topDocs, Float.NaN), SearchHits.empty(), this.metadata());
    }

    @Override
    protected void doClose() {
        Releasables.close(this.topDocsCollectors);
    }

    private static class Collectors {
        public final TopDocsCollector<?> topDocsCollector;
        public final MaxScoreCollector maxScoreCollector;
        public final Collector collector;

        Collectors(TopDocsCollector<?> topDocsCollector, MaxScoreCollector maxScoreCollector) {
            this.topDocsCollector = topDocsCollector;
            this.maxScoreCollector = maxScoreCollector;
            this.collector = MultiCollector.wrap(topDocsCollector, maxScoreCollector);
        }
    }
}

