/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractScriptFieldQuery;

public final class LongScriptFieldDistanceFeatureQuery
extends AbstractScriptFieldQuery<AbstractLongFieldScript> {
    private final long origin;
    private final long pivot;

    public LongScriptFieldDistanceFeatureQuery(Script script, Function<LeafReaderContext, AbstractLongFieldScript> leafFactory, String fieldName, long origin, long pivot) {
        super(script, fieldName, leafFactory);
        this.origin = origin;
        this.pivot = pivot;
    }

    @Override
    protected boolean matches(AbstractLongFieldScript scriptContext, int docId) {
        scriptContext.runForDoc(docId);
        return scriptContext.count() > 0;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        return new Weight(this){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public Scorer scorer(LeafReaderContext context) {
                return new DistanceScorer(this, (AbstractLongFieldScript)LongScriptFieldDistanceFeatureQuery.this.scriptContextFunction().apply(context), context.reader().maxDoc(), boost);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) {
                AbstractLongFieldScript script = (AbstractLongFieldScript)LongScriptFieldDistanceFeatureQuery.this.scriptContextFunction().apply(context);
                script.runForDoc(doc);
                long value = LongScriptFieldDistanceFeatureQuery.this.valueWithMinAbsoluteDistance(script);
                float score = LongScriptFieldDistanceFeatureQuery.this.score(boost, LongScriptFieldDistanceFeatureQuery.this.distanceFor(value));
                return Explanation.match((Number)Float.valueOf(score), "Distance score, computed as weight * pivot / (pivot + abs(value - origin)) from:", Explanation.match((Number)Float.valueOf(boost), "weight", new Explanation[0]), Explanation.match((Number)LongScriptFieldDistanceFeatureQuery.this.pivot, "pivot", new Explanation[0]), Explanation.match((Number)LongScriptFieldDistanceFeatureQuery.this.origin, "origin", new Explanation[0]), Explanation.match((Number)value, "current value", new Explanation[0]));
            }
        };
    }

    long minAbsoluteDistance(AbstractLongFieldScript script) {
        long minDistance = Long.MAX_VALUE;
        for (int i = 0; i < script.count(); ++i) {
            minDistance = Math.min(minDistance, this.distanceFor(script.values()[i]));
        }
        return minDistance;
    }

    long valueWithMinAbsoluteDistance(AbstractLongFieldScript script) {
        long minDistance = Long.MAX_VALUE;
        long minDistanceValue = Long.MAX_VALUE;
        for (int i = 0; i < script.count(); ++i) {
            long distance = this.distanceFor(script.values()[i]);
            if (distance >= minDistance) continue;
            minDistance = distance;
            minDistanceValue = script.values()[i];
        }
        return minDistanceValue;
    }

    long distanceFor(long value) {
        long distance = Math.max(value, this.origin) - Math.min(value, this.origin);
        if (distance < 0L) {
            return Long.MAX_VALUE;
        }
        return distance;
    }

    float score(float weight, double distance) {
        return (float)((double)weight * ((double)this.pivot / ((double)this.pivot + distance)));
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.fieldName().equals(field)) {
            b.append(this.fieldName()).append(":");
        }
        b.append(this.getClass().getSimpleName());
        b.append("(origin=").append(this.origin);
        b.append(",pivot=").append(this.pivot).append(")");
        return b.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.origin, this.pivot);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LongScriptFieldDistanceFeatureQuery other = (LongScriptFieldDistanceFeatureQuery)obj;
        return this.origin == other.origin && this.pivot == other.pivot;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName())) {
            visitor.visitLeaf(this);
        }
    }

    long origin() {
        return this.origin;
    }

    long pivot() {
        return this.pivot;
    }

    private class DistanceScorer
    extends Scorer {
        private final AbstractLongFieldScript script;
        private final TwoPhaseIterator twoPhase;
        private final DocIdSetIterator disi;
        private final float weight;

        protected DistanceScorer(Weight weight, final AbstractLongFieldScript script, int maxDoc, float boost) {
            super(weight);
            this.script = script;
            this.twoPhase = new TwoPhaseIterator(DocIdSetIterator.all(maxDoc)){

                @Override
                public boolean matches() {
                    return LongScriptFieldDistanceFeatureQuery.this.matches(script, this.approximation.docID());
                }

                @Override
                public float matchCost() {
                    return 9000.0f;
                }
            };
            this.disi = TwoPhaseIterator.asDocIdSetIterator(this.twoPhase);
            this.weight = boost;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.disi;
        }

        @Override
        public TwoPhaseIterator twoPhaseIterator() {
            return this.twoPhase;
        }

        @Override
        public float getMaxScore(int upTo) {
            return this.weight;
        }

        @Override
        public float score() {
            if (this.script.count() == 0) {
                return 0.0f;
            }
            return LongScriptFieldDistanceFeatureQuery.this.score(this.weight, LongScriptFieldDistanceFeatureQuery.this.minAbsoluteDistance(this.script));
        }
    }
}

