/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.phrase.CandidateGenerator;
import org.elasticsearch.search.suggest.phrase.Correction;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.MultiCandidateGeneratorWrapper;
import org.elasticsearch.search.suggest.phrase.NoisyChannelSpellChecker;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionContext;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public final class PhraseSuggester
extends Suggester<PhraseSuggestionContext> {
    private final BytesRef SEPARATOR = new BytesRef(" ");
    private static final String SUGGESTION_TEMPLATE_VAR_NAME = "suggestion";
    public static final PhraseSuggester INSTANCE = new PhraseSuggester();

    private PhraseSuggester() {
    }

    @Override
    public Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, PhraseSuggestionContext suggestion, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        double realWordErrorLikelihood = suggestion.realworldErrorLikelihood().floatValue();
        PhraseSuggestion response = new PhraseSuggestion(name, suggestion.getSize());
        IndexReader indexReader = searcher.getIndexReader();
        List<PhraseSuggestionContext.DirectCandidateGenerator> generators = suggestion.generators();
        int numGenerators = generators.size();
        ArrayList<DirectCandidateGenerator> gens = new ArrayList<DirectCandidateGenerator>(generators.size());
        for (int i = 0; i < numGenerators; ++i) {
            PhraseSuggestionContext.DirectCandidateGenerator generator = generators.get(i);
            DirectSpellChecker directSpellChecker = generator.createDirectSpellChecker();
            Terms terms = MultiTerms.getTerms(indexReader, generator.field());
            if (terms == null) continue;
            gens.add(new DirectCandidateGenerator(directSpellChecker, generator.field(), generator.suggestMode(), indexReader, realWordErrorLikelihood, generator.size(), generator.preFilter(), generator.postFilter(), terms));
        }
        String suggestField = suggestion.getField();
        Terms suggestTerms = MultiTerms.getTerms(indexReader, suggestField);
        if (gens.size() > 0 && suggestTerms != null) {
            NoisyChannelSpellChecker.Result checkerResult;
            NoisyChannelSpellChecker checker = new NoisyChannelSpellChecker(realWordErrorLikelihood, suggestion.getRequireUnigram(), suggestion.getTokenLimit());
            BytesRef separator = suggestion.separator();
            WordScorer wordScorer = suggestion.model().newScorer(indexReader, suggestTerms, suggestField, realWordErrorLikelihood, separator);
            try (TokenStream stream = PhraseSuggester.tokenStream(suggestion.getAnalyzer(), suggestion.getText(), spare, suggestion.getField());){
                checkerResult = checker.getCorrections(stream, new MultiCandidateGeneratorWrapper(suggestion.getShardSize(), gens.toArray(new CandidateGenerator[gens.size()])), suggestion.maxErrors(), suggestion.getShardSize(), wordScorer, suggestion.confidence(), suggestion.gramSize());
            }
            PhraseSuggestion.Entry resultEntry = PhraseSuggester.buildResultEntry(suggestion, spare, checkerResult.cutoffScore);
            response.addTerm(resultEntry);
            BytesRefBuilder byteSpare = new BytesRefBuilder();
            TemplateScript.Factory scriptFactory = suggestion.getCollateQueryScript();
            boolean collatePrune = scriptFactory != null && suggestion.collatePrune();
            for (int i = 0; i < checkerResult.corrections.length; ++i) {
                Correction correction = checkerResult.corrections[i];
                spare.copyUTF8Bytes(correction.join(this.SEPARATOR, byteSpare, null, null));
                boolean collateMatch = true;
                if (scriptFactory != null) {
                    Map<String, Object> vars = suggestion.getCollateScriptParams();
                    vars.put(SUGGESTION_TEMPLATE_VAR_NAME, spare.toString());
                    SearchExecutionContext searchExecutionContext = suggestion.getSearchExecutionContext();
                    String querySource = scriptFactory.newInstance(vars).execute();
                    try (XContentParser parser = XContentFactory.xContent(querySource).createParser(searchExecutionContext.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, querySource);){
                        QueryBuilder innerQueryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
                        ParsedQuery parsedQuery = searchExecutionContext.toQuery(innerQueryBuilder);
                        collateMatch = Lucene.exists(searcher, parsedQuery.query());
                    }
                }
                if (!collateMatch && !collatePrune) continue;
                Text phrase = new Text(spare.toString());
                Text highlighted = null;
                if (suggestion.getPreTag() != null) {
                    spare.copyUTF8Bytes(correction.join(this.SEPARATOR, byteSpare, suggestion.getPreTag(), suggestion.getPostTag()));
                    highlighted = new Text(spare.toString());
                }
                if (collatePrune) {
                    resultEntry.addOption(new PhraseSuggestion.Entry.Option(phrase, highlighted, (float)correction.score, collateMatch));
                    continue;
                }
                resultEntry.addOption(new PhraseSuggestion.Entry.Option(phrase, highlighted, (float)correction.score));
            }
        } else {
            response.addTerm(PhraseSuggester.buildResultEntry(suggestion, spare, Double.MIN_VALUE));
        }
        return response;
    }

    private static TokenStream tokenStream(Analyzer analyzer, BytesRef query, CharsRefBuilder spare, String field) throws IOException {
        spare.copyUTF8Bytes(query);
        return analyzer.tokenStream(field, new CharArrayReader(spare.chars(), 0, spare.length()));
    }

    private static PhraseSuggestion.Entry buildResultEntry(SuggestionSearchContext.SuggestionContext suggestion, CharsRefBuilder spare, double cutoffScore) {
        spare.copyUTF8Bytes(suggestion.getText());
        return new PhraseSuggestion.Entry(new Text(spare.toString()), 0, spare.length(), cutoffScore);
    }

    @Override
    protected Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> emptySuggestion(String name, PhraseSuggestionContext suggestion, CharsRefBuilder spare) throws IOException {
        PhraseSuggestion phraseSuggestion = new PhraseSuggestion(name, suggestion.getSize());
        spare.copyUTF8Bytes(suggestion.getText());
        phraseSuggestion.addTerm(new PhraseSuggestion.Entry(new Text(spare.toString()), 0, spare.length()));
        return phraseSuggestion;
    }
}

