/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;

public class CcrAutoFollowInfoFetcher {
    private CcrAutoFollowInfoFetcher() {
    }

    public static void getAutoFollowedSystemIndices(Client client, ClusterState state, ActionListener<List<String>> listener) {
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)state.metadata().custom("ccr_auto_follow");
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        if (autoFollowMetadata == null || !CcrAutoFollowInfoFetcher.areShardFollowTasksRunning(persistentTasks)) {
            listener.onResponse(Collections.emptyList());
            return;
        }
        List followedLeaderIndexUUIDs = autoFollowMetadata.getFollowedLeaderIndexUUIDs().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<String, List> remoteClusterAutoFollowedIndices = new HashMap<String, List>();
        for (ObjectObjectCursor<String, IndexMetadata> objectObjectCursor : state.metadata().getIndices()) {
            IndexMetadata indexMetadata = (IndexMetadata)objectObjectCursor.value;
            Map<String, String> ccrMetadata = indexMetadata.getCustomData("ccr");
            if (ccrMetadata == null) continue;
            String leaderIndexUUID = ccrMetadata.get("leader_index_uuid");
            String leaderIndexName = ccrMetadata.get("leader_index_name");
            String remoteCluster = ccrMetadata.get("remote_cluster_name");
            Index followerIndex = indexMetadata.getIndex();
            if (!followedLeaderIndexUUIDs.contains(leaderIndexUUID) || !CcrAutoFollowInfoFetcher.isCurrentlyFollowed(persistentTasks, followerIndex)) continue;
            List autoFollowedIndices = remoteClusterAutoFollowedIndices.computeIfAbsent(remoteCluster, unused -> new ArrayList());
            autoFollowedIndices.add(new AutoFollowedIndex(leaderIndexName, followerIndex.getName()));
        }
        if (remoteClusterAutoFollowedIndices.isEmpty()) {
            listener.onResponse(Collections.emptyList());
            return;
        }
        final GroupedActionListener clusterResponsesListener = new GroupedActionListener(listener.map(clusterAutoFollowedSystemIndices -> clusterAutoFollowedSystemIndices.stream().flatMap(Collection::stream).collect(Collectors.toList())), remoteClusterAutoFollowedIndices.size());
        for (Map.Entry remoteAutoFollowedIndicesEntry : remoteClusterAutoFollowedIndices.entrySet()) {
            String remoteCluster = (String)remoteAutoFollowedIndicesEntry.getKey();
            final List autoFollowedIndices = (List)remoteAutoFollowedIndicesEntry.getValue();
            try {
                client.getRemoteClusterClient(remoteCluster).admin().cluster().prepareState().clear().setMetadata(true).execute(new ActionListener<ClusterStateResponse>(){

                    @Override
                    public void onResponse(ClusterStateResponse stateResponse) {
                        ClusterState clusterState = stateResponse.getState();
                        ArrayList<String> autoFollowedSystemIndices = new ArrayList<String>();
                        for (AutoFollowedIndex autoFollowedIndex : autoFollowedIndices) {
                            IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(autoFollowedIndex.remoteIndexName);
                            if (indexAbstraction == null || !indexAbstraction.isSystem()) continue;
                            autoFollowedSystemIndices.add(autoFollowedIndex.localIndexName);
                        }
                        clusterResponsesListener.onResponse(autoFollowedSystemIndices);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        clusterResponsesListener.onFailure(e);
                    }
                });
            }
            catch (IllegalArgumentException e) {
                clusterResponsesListener.onFailure(e);
            }
        }
    }

    private static boolean isCurrentlyFollowed(PersistentTasksCustomMetadata persistentTasks, Index index) {
        return persistentTasks != null && persistentTasks.findTasks("xpack/ccr/shard_follow_task", task -> true).stream().map(task -> (ShardFollowTask)task.getParams()).anyMatch(shardFollowTask -> index.equals(shardFollowTask.getFollowShardId().getIndex()));
    }

    private static boolean areShardFollowTasksRunning(PersistentTasksCustomMetadata persistentTasks) {
        return persistentTasks != null && !persistentTasks.findTasks("xpack/ccr/shard_follow_task", task -> true).isEmpty();
    }

    private static class AutoFollowedIndex {
        private final String remoteIndexName;
        private final String localIndexName;

        private AutoFollowedIndex(String remoteIndexName, String localIndexName) {
            this.remoteIndexName = remoteIndexName;
            this.localIndexName = localIndexName;
        }
    }
}

